/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.MutableHttpHeaders;

public class JacksonAsyncHttpClientResponseEntityMapper<T>
implements HttpClientResponseMapper<CompletionStage<HttpResponseEntity<T>>> {
    private final ObjectReader objectReader;

    public JacksonAsyncHttpClientResponseEntityMapper(ObjectMapper objectMapper, JavaType jacksonType) {
        this.objectReader = objectMapper.readerFor(jacksonType);
    }

    public JacksonAsyncHttpClientResponseEntityMapper(ObjectMapper objectMapper, TypeReference<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    public JacksonAsyncHttpClientResponseEntityMapper(ObjectMapper objectMapper, TypeRef<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    @Nullable
    public CompletionStage<HttpResponseEntity<T>> apply(@Nonnull HttpClientResponse response) throws HttpClientDecoderException {
        return FlowUtils.toByteArrayFuture((Flow.Publisher)response.body()).thenApply(bytes -> {
            try {
                Object value = this.objectReader.readValue(bytes);
                return HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), (Object)value);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

