/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.ByteBufferInputStream;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public final class JacksonAsyncHttpServerRequestMapper<T>
implements HttpServerRequestMapper<CompletionStage<T>> {
    private final ObjectReader objectMapper;

    public JacksonAsyncHttpServerRequestMapper(ObjectMapper objectMapper, Type type) {
        this.objectMapper = objectMapper.readerFor(objectMapper.constructType(type));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletionStage<T> apply(HttpServerRequest request) {
        HttpBodyInput body = request.body();
        ByteBuffer fullContent = body.getFullContentIfAvailable();
        if (fullContent == null) return FlowUtils.toByteArrayFuture((Flow.Publisher)request.body()).thenApply(bytes -> {
            try {
                return this.objectMapper.readValue(bytes);
            }
            catch (Exception e) {
                throw HttpServerResponseException.of((int)400, (Throwable)e);
            }
        });
        try (HttpBodyInput httpBodyInput = body;){
            if (fullContent.hasArray()) {
                CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(this.objectMapper.readValue(fullContent.array(), fullContent.arrayOffset(), fullContent.remaining()));
                return completableFuture2;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(this.objectMapper.readValue((InputStream)new ByteBufferInputStream(fullContent)));
            return completableFuture;
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture((Throwable)HttpServerResponseException.of((int)400, (Throwable)e));
        }
    }
}

