/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.jackson.module.http.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;

public class JacksonAsyncHttpClientResponseMapper<T>
implements HttpClientResponseMapper<CompletionStage<T>> {
    private final ObjectReader objectReader;

    private JacksonAsyncHttpClientResponseMapper(ObjectMapper objectMapper, JavaType jacksonType) {
        this.objectReader = objectMapper.readerFor(jacksonType);
    }

    public JacksonAsyncHttpClientResponseMapper(ObjectMapper objectMapper, TypeReference<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    public JacksonAsyncHttpClientResponseMapper(ObjectMapper objectMapper, TypeRef<T> type) {
        this(objectMapper, objectMapper.constructType(type));
    }

    public CompletionStage<T> apply(HttpClientResponse response) {
        return FlowUtils.toByteArrayFuture((Flow.Publisher)response.body()).thenApply(bytes -> {
            Object object;
            block8: {
                JsonParser p = this.objectReader.createParser(bytes);
                try {
                    object = this.objectReader.readValue(p);
                    if (p == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (p != null) {
                            try {
                                p.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new HttpClientDecoderException((Throwable)e);
                    }
                }
                p.close();
            }
            return object;
        });
    }
}

