/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.jms.telemetry;

import javax.annotation.Nullable;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerLogger;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerMetrics;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerTelemetry;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerTracer;

public final class DefaultJmsConsumerTelemetry
implements JmsConsumerTelemetry {
    @Nullable
    private final JmsConsumerTracer tracing;
    @Nullable
    private final JmsConsumerMetrics metrics;
    @Nullable
    private final JmsConsumerLogger logger;

    public DefaultJmsConsumerTelemetry(@Nullable JmsConsumerTracer tracing, @Nullable JmsConsumerMetrics metrics, @Nullable JmsConsumerLogger logger) {
        this.tracing = tracing;
        this.metrics = metrics;
        this.logger = logger;
    }

    @Override
    public JmsConsumerTelemetry.JmsConsumerTelemetryContext get(Message message) throws JMSException {
        JmsConsumerTracer.JmsConsumerSpan span;
        long start = System.nanoTime();
        JmsConsumerTracer.JmsConsumerSpan jmsConsumerSpan = span = this.tracing == null ? null : this.tracing.get(message);
        if (this.logger != null) {
            this.logger.onMessageReceived(message);
        }
        return e -> {
            long duration = System.nanoTime() - start;
            if (this.logger != null) {
                this.logger.onMessageProcessed(message, duration);
            }
            if (this.metrics != null) {
                this.metrics.onMessageProcessed(message, duration);
            }
            if (span != null) {
                span.close(duration, e);
            }
        };
    }
}

