/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.jms;

import java.io.Closeable;
import java.io.IOException;
import javax.jms.ConnectionFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.util.ReactorUtils;

public class JmsConnectionFactory
implements Lifecycle,
Wrapped<ConnectionFactory> {
    private final ConnectionFactory connectionFactory;

    public JmsConnectionFactory(ConnectionFactory connectionFactory, String name) {
        this.connectionFactory = connectionFactory;
    }

    public Mono<Void> init() {
        return ReactorUtils.ioMono(() -> {});
    }

    public Mono<Void> release() {
        return ReactorUtils.ioMono(() -> {
            if (this.connectionFactory instanceof Closeable) {
                try {
                    ((Closeable)this.connectionFactory).close();
                }
                catch (IOException e) {
                    throw Exceptions.bubble((Throwable)e);
                }
            }
        });
    }

    public ConnectionFactory value() {
        return this.connectionFactory;
    }
}

