/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.jms;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.TextMessage;

public final class JmsUtils {
    public static String REPLY_TO = "JMSReplyTo";

    private JmsUtils() {
    }

    public static String text(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)message;
            bm.reset();
            byte[] bytes = new byte[(int)bm.getBodyLength()];
            bm.readBytes(bytes);
            bm.reset();
            return new String(bytes, StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Can't parse to string message of class " + message.getClass().getSimpleName());
    }

    public static byte[] bytes(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText().getBytes(StandardCharsets.UTF_8);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)message;
            bm.reset();
            byte[] bytes = new byte[(int)bm.getBodyLength()];
            bm.readBytes(bytes);
            bm.reset();
            return bytes;
        }
        throw new IllegalArgumentException("Can't parse to bytes message of class " + message.getClass().getSimpleName());
    }

    public static Map<String, String> dumpHeaders(Message message) throws JMSException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name);
            result.put(name, Objects.toString(value));
        }
        return result;
    }

    public static void appendHeaders(Message jmsMessage, Map<String, Object> headers) throws JMSException {
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            if (header.getKey().equals(REPLY_TO)) {
                jmsMessage.setJMSReplyTo((Destination)header.getValue());
                continue;
            }
            if (header.getValue() instanceof String) {
                jmsMessage.setStringProperty(header.getKey(), (String)header.getValue());
                continue;
            }
            if (header.getValue() instanceof Integer) {
                jmsMessage.setIntProperty(header.getKey(), ((Integer)header.getValue()).intValue());
                continue;
            }
            throw new JMSRuntimeException("Invalid property type: " + String.valueOf(header.getValue().getClass()));
        }
    }
}

