/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.jms.telemetry;

import jakarta.annotation.Nullable;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerLogger;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerMetrics;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerTelemetry;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerTracer;

public final class DefaultJmsConsumerTelemetry
implements JmsConsumerTelemetry {
    private static final JmsConsumerTelemetry.JmsConsumerTelemetryContext NOOP_CTX = e -> {};
    @Nullable
    private final JmsConsumerTracer tracing;
    @Nullable
    private final JmsConsumerMetrics metrics;
    @Nullable
    private final JmsConsumerLogger logger;

    public DefaultJmsConsumerTelemetry(@Nullable JmsConsumerTracer tracing, @Nullable JmsConsumerMetrics metrics, @Nullable JmsConsumerLogger logger) {
        this.tracing = tracing;
        this.metrics = metrics;
        this.logger = logger;
    }

    @Override
    public JmsConsumerTelemetry.JmsConsumerTelemetryContext get(Message message) throws JMSException {
        JmsConsumerTracer.JmsConsumerSpan span;
        JmsConsumerTracer tracing = this.tracing;
        JmsConsumerMetrics metrics = this.metrics;
        JmsConsumerLogger logger = this.logger;
        if (!(tracing != null || metrics != null || logger != null && logger.isEnabled())) {
            return NOOP_CTX;
        }
        long start = System.nanoTime();
        JmsConsumerTracer.JmsConsumerSpan jmsConsumerSpan = span = tracing == null ? null : tracing.get(message);
        if (logger != null) {
            logger.onMessageReceived(message);
        }
        return e -> {
            long duration = System.nanoTime() - start;
            if (logger != null) {
                logger.onMessageProcessed(message, duration);
            }
            if (metrics != null) {
                metrics.onMessageProcessed(message, duration);
            }
            if (span != null) {
                span.close(e);
            }
        };
    }
}

