/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.config;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import ru.tinkoff.kora.common.util.Either;

public record KafkaConsumerConfig(Properties driverProperties, @Nullable List<String> topics, @Nullable Pattern topicsPattern, @Nullable List<String> partitions, Either<Duration, String> offset, Duration pollTimeout, Duration backoffTimeout, int threads) {
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_BACKOFF_TIMEOUT = Duration.ofSeconds(15L);
    private static final int DEFAULT_THREADS_COUNT = 1;
    private static final Either<Duration, String> DEFAULT_OFFSET = Either.right((Object)"latest");

    public KafkaConsumerConfig(Properties driverProperties, @Nullable List<String> topics, @Nullable Pattern topicsPattern, @Nullable List<String> partitions, @Nullable Either<Duration, String> offset, @Nullable Duration pollTimeout, @Nullable Duration backoffTimeout, @Nullable Integer threads) {
        this(driverProperties, topics, topicsPattern, partitions, offset == null ? DEFAULT_OFFSET : offset, pollTimeout == null ? DEFAULT_POLL_TIMEOUT : pollTimeout, backoffTimeout == null ? DEFAULT_BACKOFF_TIMEOUT : backoffTimeout, threads == null ? 1 : threads);
        if (topics == null && topicsPattern == null && partitions == null) {
            throw new IllegalArgumentException("`topics` or `topicsPattern` or `partitions` must be specified");
        }
    }

    public KafkaConsumerConfig withDriverPropertiesOverrides(Map<String, Object> overrides) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.driverProperties);
        props.putAll(overrides);
        return new KafkaConsumerConfig(props, this.topics, this.topicsPattern, this.partitions, this.offset, this.pollTimeout, this.backoffTimeout, this.threads);
    }
}

