/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.containers;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import ru.tinkoff.kora.kafka.common.exceptions.RecordKeyDeserializationException;
import ru.tinkoff.kora.kafka.common.exceptions.RecordValueDeserializationException;

public final class ConsumerRecordWrapper<K, V>
extends ConsumerRecord<K, V> {
    private final ConsumerRecord<byte[], byte[]> realRecord;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final AtomicReference<K> deserializedKey = new AtomicReference<Object>(null);
    private final AtomicReference<V> deserializedValue = new AtomicReference<Object>(null);

    public ConsumerRecordWrapper(ConsumerRecord<byte[], byte[]> realRecord, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        super(realRecord.topic(), realRecord.partition(), realRecord.offset(), null, null);
        this.realRecord = realRecord;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public String topic() {
        return this.realRecord.topic();
    }

    public int partition() {
        return this.realRecord.partition();
    }

    public Headers headers() {
        return this.realRecord.headers();
    }

    public K key() {
        Object value = this.deserializedKey.get();
        if (value == null) {
            try {
                value = this.keyDeserializer.deserialize(this.realRecord.topic(), this.realRecord.headers(), (byte[])this.realRecord.key());
            }
            catch (Exception e) {
                throw new RecordKeyDeserializationException(e, this.realRecord);
            }
            this.deserializedKey.set(value);
        }
        return value;
    }

    public V value() {
        Object value = this.deserializedValue.get();
        if (value == null) {
            try {
                value = this.valueDeserializer.deserialize(this.realRecord.topic(), this.realRecord.headers(), (byte[])this.realRecord.value());
            }
            catch (Exception e) {
                throw new RecordValueDeserializationException(e, this.realRecord);
            }
            this.deserializedValue.set(value);
        }
        return value;
    }

    public long offset() {
        return this.realRecord.offset();
    }

    public long timestamp() {
        return this.realRecord.timestamp();
    }

    public TimestampType timestampType() {
        return this.realRecord.timestampType();
    }

    public int serializedKeySize() {
        return this.realRecord.serializedKeySize();
    }

    public int serializedValueSize() {
        return this.realRecord.serializedValueSize();
    }

    public Optional<Integer> leaderEpoch() {
        return this.realRecord.leaderEpoch();
    }

    public String toString() {
        return this.realRecord.toString();
    }
}

