/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.telemetry;

import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import ru.tinkoff.kora.kafka.common.telemetry.KafkaConsumerLogger;
import ru.tinkoff.kora.kafka.common.telemetry.KafkaConsumerMetrics;
import ru.tinkoff.kora.kafka.common.telemetry.KafkaConsumerTelemetry;
import ru.tinkoff.kora.kafka.common.telemetry.KafkaConsumerTracer;

public class DefaultKafkaConsumerTelemetry<K, V>
implements KafkaConsumerTelemetry<K, V> {
    @Nullable
    private final KafkaConsumerLogger<K, V> logger;
    @Nullable
    private final KafkaConsumerTracer tracing;
    @Nullable
    private final KafkaConsumerMetrics metrics;

    public DefaultKafkaConsumerTelemetry(@Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerTracer tracing, @Nullable KafkaConsumerMetrics metrics) {
        this.logger = logger;
        this.tracing = tracing;
        this.metrics = metrics;
    }

    @Override
    public KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V> get(ConsumerRecords<K, V> records) {
        long start = System.nanoTime();
        if (this.metrics != null) {
            this.metrics.onRecordsReceived(records);
        }
        if (this.logger != null) {
            this.logger.logRecords(records);
        }
        KafkaConsumerTracer.KafkaConsumerRecordsSpan span = this.tracing == null ? null : this.tracing.get(records);
        return new DefaultKafkaConsumerRecordsTelemetryContext<K, V>(records, this.logger, this.metrics, span, start);
    }

    private static final class DefaultKafkaConsumerRecordsTelemetryContext<K, V>
    implements KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V> {
        private final ConsumerRecords<K, V> records;
        @Nullable
        private final KafkaConsumerLogger<K, V> logger;
        @Nullable
        private final KafkaConsumerMetrics metrics;
        @Nullable
        private final KafkaConsumerTracer.KafkaConsumerRecordsSpan span;
        private final long start;

        public DefaultKafkaConsumerRecordsTelemetryContext(ConsumerRecords<K, V> records, @Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerMetrics metrics, @Nullable KafkaConsumerTracer.KafkaConsumerRecordsSpan span, long start) {
            this.records = records;
            this.logger = logger;
            this.metrics = metrics;
            this.span = span;
            this.start = start;
        }

        @Override
        public KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext<K, V> get(ConsumerRecord<K, V> record) {
            KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan;
            long recordStart = System.nanoTime();
            KafkaConsumerTracer.KafkaConsumerRecordSpan kafkaConsumerRecordSpan = recordSpan = this.span == null ? null : this.span.get(record);
            if (this.logger != null) {
                this.logger.logRecord(record);
            }
            return new DefaultKafkaConsumerRecordTelemetryContext<K, V>(record, recordStart, this.logger, this.metrics, recordSpan);
        }

        @Override
        public void close(@Nullable Throwable ex) {
            long duration = System.nanoTime() - this.start;
            if (this.span != null) {
                this.span.close(duration, ex);
            }
            if (this.metrics != null) {
                this.metrics.onRecordsProcessed(this.records, duration, ex);
            }
            if (this.logger != null) {
                this.logger.logRecordsProcessed(this.records, ex);
            }
        }
    }

    private static final class DefaultKafkaConsumerRecordTelemetryContext<K, V>
    implements KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext<K, V> {
        private final ConsumerRecord<K, V> record;
        private final long recordStart;
        @Nullable
        private final KafkaConsumerLogger<K, V> logger;
        @Nullable
        private final KafkaConsumerMetrics metrics;
        @Nullable
        private final KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan;

        public DefaultKafkaConsumerRecordTelemetryContext(ConsumerRecord<K, V> record, long recordStart, @Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerMetrics metrics, @Nullable KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan) {
            this.record = record;
            this.recordStart = recordStart;
            this.logger = logger;
            this.metrics = metrics;
            this.recordSpan = recordSpan;
        }

        @Override
        public void close(@Nullable Throwable ex) {
            long duration = System.nanoTime() - this.recordStart;
            if (this.recordSpan != null) {
                this.recordSpan.close(duration, ex);
            }
            if (this.metrics != null) {
                this.metrics.onRecordProcessed(this.record, duration, ex);
            }
            if (this.logger != null) {
                this.logger.logRecordProcessed(this.record, ex);
            }
        }
    }
}

