/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import ru.tinkoff.kora.kafka.common.config.KafkaConsumerConfig;
import ru.tinkoff.kora.kafka.common.containers.ConsumerWrapper;

public interface KafkaConsumerFactory<K, V> {
    public Consumer<K, V> buildConsumer();

    public static <K, V> KafkaConsumerFactory<K, V> subscribe(KafkaConsumerConfig consumerConfig, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new SubscribeKafkaConsumerFactory<K, V>(consumerConfig, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaConsumerFactory<K, V> assign(KafkaConsumerConfig consumerConfig, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new AssignKafkaConsumerFactory<K, V>(consumerConfig, keyDeserializer, valueDeserializer);
    }

    public static final class SubscribeKafkaConsumerFactory<K, V>
    implements KafkaConsumerFactory<K, V> {
        private final KafkaConsumerConfig consumerConfig;
        private final Deserializer<K> keyDeserializer;
        private final Deserializer<V> valueDeserializer;

        public SubscribeKafkaConsumerFactory(KafkaConsumerConfig consumerConfig, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
            this.consumerConfig = consumerConfig;
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
        }

        @Override
        public Consumer<K, V> buildConsumer() {
            KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig.driverProperties(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
            try {
                if (this.consumerConfig.topicsPattern() != null) {
                    consumer.subscribe(this.consumerConfig.topicsPattern());
                } else if (this.consumerConfig.topics() != null) {
                    consumer.subscribe(this.consumerConfig.topics());
                }
            }
            catch (Exception e) {
                try {
                    consumer.close();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            return new ConsumerWrapper<K, V>((Consumer<byte[], byte[]>)consumer, this.keyDeserializer, this.valueDeserializer);
        }
    }

    public static final class AssignKafkaConsumerFactory<K, V>
    implements KafkaConsumerFactory<K, V> {
        private final KafkaConsumerConfig consumerConfig;
        private final Deserializer<K> keyDeserializer;
        private final Deserializer<V> valueDeserializer;

        public AssignKafkaConsumerFactory(KafkaConsumerConfig consumerConfig, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
            this.consumerConfig = consumerConfig;
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
        }

        @Override
        public Consumer<K, V> buildConsumer() {
            KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig.driverProperties(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
            try {
                ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
                if (this.consumerConfig.partitions() != null) {
                    for (String partition : this.consumerConfig.partitions()) {
                        String[] split = partition.split(":");
                        partitions.add(new TopicPartition(split[0], Integer.parseInt(split[1])));
                    }
                } else {
                    for (String topic : this.consumerConfig.topics()) {
                        List partitionsInfo = consumer.partitionsFor(topic);
                        for (PartitionInfo info : partitionsInfo) {
                            partitions.add(new TopicPartition(info.topic(), info.partition()));
                        }
                    }
                }
                consumer.assign(partitions);
                if (this.consumerConfig.offset().left() != null) {
                    long from = System.currentTimeMillis() - ((Duration)this.consumerConfig.offset().left()).toMillis();
                    HashMap<TopicPartition, Long> seekTimestamps = new HashMap<TopicPartition, Long>();
                    for (TopicPartition tp : partitions) {
                        seekTimestamps.put(tp, from);
                    }
                    Map offsets = consumer.offsetsForTimes(seekTimestamps);
                    for (TopicPartition tp : partitions) {
                        OffsetAndTimestamp offset = (OffsetAndTimestamp)offsets.get(tp);
                        if (offset == null) {
                            consumer.seekToEnd(List.of(tp));
                            continue;
                        }
                        consumer.seek(tp, offset.offset());
                    }
                } else if ("earliest".equals(((String)this.consumerConfig.offset().right()).toLowerCase().trim())) {
                    consumer.seekToBeginning(partitions);
                } else {
                    consumer.seekToEnd(partitions);
                }
            }
            catch (Exception e) {
                try {
                    consumer.close();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            return new ConsumerWrapper<K, V>((Consumer<byte[], byte[]>)consumer, this.keyDeserializer, this.valueDeserializer);
        }
    }
}

