/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.producer;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.kafka.common.producer.PublisherConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $PublisherConfig_TransactionConfig_ConfigValueExtractor
implements ConfigValueExtractor<PublisherConfig.TransactionConfig> {
    public static final TransactionConfig_Defaults DEFAULTS = new TransactionConfig_Defaults();
    private static final PathElement.Key _idPrefix_path = PathElement.get((String)"idPrefix");
    private static final PathElement.Key _maxPoolSize_path = PathElement.get((String)"maxPoolSize");
    private static final PathElement.Key _maxWaitTime_path = PathElement.get((String)"maxWaitTime");
    private final ConfigValueExtractor<Duration> extractor1;
    private final ConfigValueExtractor<Duration> maxWaitTime_parser;

    public $PublisherConfig_TransactionConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1) {
        this.extractor1 = extractor1;
        this.maxWaitTime_parser = extractor1;
    }

    public PublisherConfig.TransactionConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String idPrefix = this.parse_idPrefix(_config);
        int maxPoolSize = this.parse_maxPoolSize(_config);
        Duration maxWaitTime = this.parse_maxWaitTime(_config);
        return new TransactionConfig_Impl(idPrefix, maxPoolSize, maxWaitTime);
    }

    private String parse_idPrefix(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_idPrefix_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private int parse_maxPoolSize(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxPoolSize_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.maxPoolSize();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private Duration parse_maxWaitTime(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxWaitTime_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.maxWaitTime();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.maxWaitTime_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    public record TransactionConfig_Impl(String idPrefix, int maxPoolSize, Duration maxWaitTime) implements PublisherConfig.TransactionConfig
    {
        public TransactionConfig_Impl {
            Objects.requireNonNull(idPrefix);
            Objects.requireNonNull(maxWaitTime);
        }
    }

    public static final class TransactionConfig_Defaults
    implements PublisherConfig.TransactionConfig {
        @Override
        public String idPrefix() {
            return null;
        }
    }
}

