/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.config;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.kafka.common.config.$KafkaConsumerConfig_ConfigValueExtractor;

@ConfigValueExtractor
public interface KafkaConsumerConfig {
    public Properties driverProperties();

    @Nullable
    public List<String> topics();

    @Nullable
    public Pattern topicsPattern();

    @Nullable
    public List<String> partitions();

    default public Either<Duration, String> offset() {
        return Either.right((Object)"latest");
    }

    default public Duration pollTimeout() {
        return Duration.ofSeconds(5L);
    }

    default public Duration backoffTimeout() {
        return Duration.ofSeconds(15L);
    }

    default public int threads() {
        return 1;
    }

    default public Duration partitionRefreshInterval() {
        return Duration.ofMinutes(1L);
    }

    default public KafkaConsumerConfig withDriverPropertiesOverrides(Map<String, Object> overrides) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.driverProperties());
        props.putAll(overrides);
        return new $KafkaConsumerConfig_ConfigValueExtractor.KafkaConsumerConfig_Impl(props, this.topics(), this.topicsPattern(), this.partitions(), this.offset(), this.pollTimeout(), this.backoffTimeout(), this.threads(), this.partitionRefreshInterval());
    }
}

