/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.producer;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import ru.tinkoff.kora.kafka.common.producer.TransactionalProducerImpl;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTelemetry;

public class TransactionalProducerWrapper<K, V>
implements Producer<K, V> {
    private final TransactionalProducerImpl<K, V> pool;
    private final Producer<K, V> delegate;
    private final KafkaProducerTelemetry telemetry;
    private final TransactionalProducerImpl.ProducerWithTelemetry<K, V> producerWithTelemetry;
    private volatile TxState state = TxState.STATE_NO_TX;
    private volatile KafkaProducerTelemetry.KafkaProducerTransactionTelemetryContext txTelemetry;

    public TransactionalProducerWrapper(TransactionalProducerImpl<K, V> pool, TransactionalProducerImpl.ProducerWithTelemetry<K, V> producerWithTelemetry) {
        this.pool = pool;
        this.delegate = producerWithTelemetry.producer();
        this.telemetry = producerWithTelemetry.telemetry();
        this.producerWithTelemetry = producerWithTelemetry;
    }

    public void initTransactions() {
    }

    public void beginTransaction() throws ProducerFencedException {
        this.delegate.beginTransaction();
        this.state = TxState.STATE_IN_TX;
        this.txTelemetry = this.telemetry.tx();
    }

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
        this.state = TxState.STATE_IN_TX;
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.txTelemetry.sendOffsetsToTransaction(offsets, groupMetadata);
        this.delegate.sendOffsetsToTransaction(offsets, groupMetadata);
        this.state = TxState.STATE_IN_TX;
    }

    public void commitTransaction() throws ProducerFencedException {
        this.delegate.commitTransaction();
        this.state = TxState.STATE_NO_TX;
        this.txTelemetry.commit();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.delegate.abortTransaction();
        this.state = TxState.STATE_NO_TX;
        this.txTelemetry.rollback(null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.delegate.send(record);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        return this.delegate.send(record, callback);
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        if (this.state == TxState.STATE_IN_TX) {
            try {
                this.commitTransaction();
            }
            catch (KafkaException e) {
                this.pool.deleteFromPool(this.producerWithTelemetry);
                try {
                    this.delegate.close();
                }
                catch (Exception ex) {
                    e.addSuppressed((Throwable)ex);
                }
                throw e;
            }
        }
        this.pool.returnToPool(this.producerWithTelemetry);
    }

    public void close(Duration timeout) {
        if (this.state == TxState.STATE_IN_TX) {
            try {
                this.commitTransaction();
            }
            catch (KafkaException e) {
                this.pool.deleteFromPool(this.producerWithTelemetry);
                try {
                    this.delegate.close(timeout);
                }
                catch (Exception ex) {
                    e.addSuppressed((Throwable)ex);
                }
                throw e;
            }
        }
        this.pool.returnToPool(this.producerWithTelemetry);
    }

    private static enum TxState {
        STATE_NO_TX,
        STATE_IN_TX;

    }
}

