/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.producer.telemetry;

import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerLogger;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerLoggerFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetricsFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTelemetry;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTelemetryFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTracer;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTracerFactory;

public class DefaultKafkaProducerTelemetryFactory
implements KafkaProducerTelemetryFactory {
    @Nullable
    private final KafkaProducerTracerFactory tracerFactory;
    @Nullable
    private final KafkaProducerLoggerFactory loggerFactory;
    @Nullable
    private final KafkaProducerMetricsFactory metricsFactory;

    public DefaultKafkaProducerTelemetryFactory(@Nullable KafkaProducerTracerFactory tracerFactory, @Nullable KafkaProducerLoggerFactory loggerFactory, @Nullable KafkaProducerMetricsFactory metricsFactory) {
        this.tracerFactory = tracerFactory;
        this.loggerFactory = loggerFactory;
        this.metricsFactory = metricsFactory;
    }

    @Override
    public KafkaProducerTelemetry get(Producer<?, ?> producer, Properties properties) {
        KafkaProducerTracer tracer = this.tracerFactory == null ? null : this.tracerFactory.get(producer, properties);
        KafkaProducerLogger logger = this.loggerFactory == null ? null : this.loggerFactory.get(producer, properties);
        KafkaProducerMetrics metrics = this.metricsFactory == null ? null : this.metricsFactory.get(producer, properties);
        return new DefaultKafkaProducerTelemetry(tracer, logger, metrics);
    }

    private static final class DefaultKafkaProducerTelemetry
    implements KafkaProducerTelemetry {
        @Nullable
        private final KafkaProducerTracer tracer;
        @Nullable
        private final KafkaProducerLogger logger;
        @Nullable
        private final KafkaProducerMetrics metrics;

        public DefaultKafkaProducerTelemetry(@Nullable KafkaProducerTracer tracer, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics metrics) {
            this.tracer = tracer;
            this.logger = logger;
            this.metrics = metrics;
        }

        @Override
        public void close() {
            AutoCloseable c;
            Object object = this.tracer;
            if (object instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = this.logger) instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = this.metrics) instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public KafkaProducerTelemetry.KafkaProducerTransactionTelemetryContext tx() {
            KafkaProducerMetrics.KafkaProducerTxMetrics metrics;
            KafkaProducerTracer.KafkaProducerTxSpan span = this.tracer == null ? null : this.tracer.tx();
            KafkaProducerMetrics.KafkaProducerTxMetrics kafkaProducerTxMetrics = metrics = this.metrics == null ? null : this.metrics.tx();
            if (this.logger != null) {
                this.logger.txBegin();
            }
            return new DefaultKafkaProducerTransactionTelemetryContext(span, this.logger, metrics);
        }

        @Override
        public KafkaProducerTelemetry.KafkaProducerRecordTelemetryContext record(ProducerRecord<?, ?> record) {
            if (this.logger != null) {
                this.logger.sendBegin(record);
            }
            KafkaProducerTracer.KafkaProducerRecordSpan span = this.tracer == null ? null : this.tracer.get(record);
            return new DefaultKafkaProducerRecordTelemetryContext(record, span, this.logger, this.metrics);
        }
    }

    private static final class DefaultKafkaProducerRecordTelemetryContext
    implements KafkaProducerTelemetry.KafkaProducerRecordTelemetryContext {
        private final KafkaProducerTracer.KafkaProducerRecordSpan span;
        private final KafkaProducerLogger logger;
        private final ProducerRecord<?, ?> record;
        private final Context ctx;

        public DefaultKafkaProducerRecordTelemetryContext(ProducerRecord<?, ?> record, @Nullable KafkaProducerTracer.KafkaProducerRecordSpan span, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics metrics) {
            this.span = span;
            this.logger = logger;
            this.record = record;
            this.ctx = Context.current().fork();
        }

        @Override
        public void sendEnd(Throwable e) {
            Context oldCtx = Context.current();
            try {
                this.ctx.inject();
                if (this.logger != null) {
                    this.logger.sendEnd(this.record, e);
                }
                if (this.span != null) {
                    this.span.close(e);
                }
            }
            finally {
                oldCtx.inject();
            }
        }

        @Override
        public void sendEnd(RecordMetadata metadata) {
            Context oldCtx = Context.current();
            try {
                this.ctx.inject();
                if (this.logger != null) {
                    this.logger.sendEnd(metadata);
                }
                if (this.span != null) {
                    this.span.close(metadata);
                }
            }
            finally {
                oldCtx.inject();
            }
        }
    }

    private static final class DefaultKafkaProducerTransactionTelemetryContext
    implements KafkaProducerTelemetry.KafkaProducerTransactionTelemetryContext {
        @Nullable
        private final KafkaProducerTracer.KafkaProducerTxSpan span;
        @Nullable
        private final KafkaProducerLogger logger;
        @Nullable
        private final KafkaProducerMetrics.KafkaProducerTxMetrics metrics;

        private DefaultKafkaProducerTransactionTelemetryContext(@Nullable KafkaProducerTracer.KafkaProducerTxSpan span, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics.KafkaProducerTxMetrics metrics) {
            this.span = span;
            this.logger = logger;
            this.metrics = metrics;
        }

        @Override
        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
            if (this.logger != null) {
                this.logger.sendOffsetsToTransaction(offsets, groupMetadata);
            }
        }

        @Override
        public void commit() {
            if (this.metrics != null) {
                this.metrics.commit();
            }
            if (this.logger != null) {
                this.logger.txCommit();
            }
            if (this.span != null) {
                this.span.commit();
            }
        }

        @Override
        public void rollback(@Nullable Throwable e) {
            if (this.metrics != null) {
                this.metrics.rollback(e);
            }
            if (this.logger != null) {
                this.logger.txRollback(e);
            }
            if (this.span != null) {
                this.span.rollback(e);
            }
        }
    }
}

