/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.producer;

import jakarta.annotation.Nullable;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;

public interface TransactionalPublisher<P> {
    public Transaction<? extends P> begin();

    default public <E extends Throwable> void inTx(TransactionalConsumer<P, E> callback) throws E {
        try (Transaction<P> p = this.begin();){
            try {
                callback.accept(p.publisher());
            }
            catch (Throwable e) {
                p.abort();
                throw e;
            }
        }
    }

    default public <E extends Throwable, R> R inTx(TransactionalFunction<P, E, R> callback) throws E {
        R r;
        block7: {
            Transaction<P> p = this.begin();
            try {
                r = callback.accept(p.publisher());
                if (p == null) break block7;
                p.close();
            }
            catch (Throwable e) {
                try {
                    p.abort();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return r;
    }

    default public <E extends Throwable> void withTx(TransactionConsumer<P, E> callback) throws E {
        try (Transaction<P> p = this.begin();){
            try {
                callback.accept(p);
            }
            catch (Throwable e) {
                p.abort();
                throw e;
            }
        }
    }

    default public <E extends Throwable, R> R withTx(TransactionFunction<P, E, R> callback) throws E {
        R r;
        block7: {
            Transaction<P> p = this.begin();
            try {
                r = callback.accept(p);
                if (p == null) break block7;
                p.close();
            }
            catch (Throwable e) {
                try {
                    p.abort();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return r;
    }

    public static interface Transaction<P>
    extends AutoCloseable {
        public P publisher();

        public Producer<byte[], byte[]> producer();

        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, ConsumerGroupMetadata var2);

        public void abort(@Nullable Throwable var1);

        default public void abort() {
            this.abort(null);
        }

        public void flush();

        @Override
        public void close();
    }

    @FunctionalInterface
    public static interface TransactionalConsumer<P, E extends Throwable> {
        public void accept(P var1) throws E;
    }

    @FunctionalInterface
    public static interface TransactionalFunction<P, E extends Throwable, R> {
        public R accept(P var1) throws E;
    }

    @FunctionalInterface
    public static interface TransactionConsumer<P, E extends Throwable> {
        public void accept(Transaction<? extends P> var1) throws E;
    }

    @FunctionalInterface
    public static interface TransactionFunction<P, E extends Throwable, R> {
        public R accept(Transaction<? extends P> var1) throws E;
    }
}

