/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common;

import jakarta.annotation.Nonnull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.kafka.common.consumer.KafkaListenerConfig;

public class KafkaUtils {
    public static String getConsumerPrefix(KafkaListenerConfig config) {
        if (config.topics() != null) {
            return String.join((CharSequence)";", config.topics());
        }
        if (config.topicsPattern() != null) {
            return config.topicsPattern().toString();
        }
        if (config.partitions() != null) {
            return String.join((CharSequence)";", config.partitions());
        }
        return "unknown";
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private static final String CONSUMER_PREFIX = "kafka-consumer-";
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public NamedThreadFactory(String prefix) {
            this.namePrefix = prefix;
        }

        @Override
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread thread = new Thread(runnable, CONSUMER_PREFIX + this.namePrefix + this.threadNumber.getAndIncrement());
            thread.setDaemon(false);
            thread.setPriority(5);
            return thread;
        }
    }
}

