/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.consumer;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.kafka.common.consumer.KafkaListenerConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $KafkaListenerConfig_ConfigValueExtractor
implements ConfigValueExtractor<KafkaListenerConfig> {
    public static final KafkaListenerConfig_Defaults DEFAULTS = new KafkaListenerConfig_Defaults();
    private static final PathElement.Key _driverProperties_path = PathElement.get((String)"driverProperties");
    private static final PathElement.Key _topics_path = PathElement.get((String)"topics");
    private static final PathElement.Key _topicsPattern_path = PathElement.get((String)"topicsPattern");
    private static final PathElement.Key _partitions_path = PathElement.get((String)"partitions");
    private static final PathElement.Key _offset_path = PathElement.get((String)"offset");
    private static final PathElement.Key _pollTimeout_path = PathElement.get((String)"pollTimeout");
    private static final PathElement.Key _backoffTimeout_path = PathElement.get((String)"backoffTimeout");
    private static final PathElement.Key _threads_path = PathElement.get((String)"threads");
    private static final PathElement.Key _partitionRefreshInterval_path = PathElement.get((String)"partitionRefreshInterval");
    private static final PathElement.Key _shutdownWait_path = PathElement.get((String)"shutdownWait");
    private static final PathElement.Key _allowEmptyRecords_path = PathElement.get((String)"allowEmptyRecords");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Properties> extractor1;
    private final ConfigValueExtractor<Properties> driverProperties_parser;
    private final ConfigValueExtractor<List<String>> extractor2;
    private final ConfigValueExtractor<List<String>> topics_parser;
    private final ConfigValueExtractor<Pattern> extractor3;
    private final ConfigValueExtractor<Pattern> topicsPattern_parser;
    private final ConfigValueExtractor<List<String>> partitions_parser;
    private final ConfigValueExtractor<Either<Duration, String>> extractor4;
    private final ConfigValueExtractor<Either<Duration, String>> offset_parser;
    private final ConfigValueExtractor<Duration> extractor5;
    private final ConfigValueExtractor<Duration> pollTimeout_parser;
    private final ConfigValueExtractor<Duration> backoffTimeout_parser;
    private final ConfigValueExtractor<Duration> partitionRefreshInterval_parser;
    private final ConfigValueExtractor<Duration> shutdownWait_parser;
    private final ConfigValueExtractor<Boolean> extractor6;
    private final ConfigValueExtractor<Boolean> allowEmptyRecords_parser;
    private final ConfigValueExtractor<TelemetryConfig> extractor7;
    private final ConfigValueExtractor<TelemetryConfig> telemetry_parser;

    public $KafkaListenerConfig_ConfigValueExtractor(ConfigValueExtractor<Properties> extractor1, ConfigValueExtractor<List<String>> extractor2, ConfigValueExtractor<Pattern> extractor3, ConfigValueExtractor<Either<Duration, String>> extractor4, ConfigValueExtractor<Duration> extractor5, ConfigValueExtractor<Boolean> extractor6, ConfigValueExtractor<TelemetryConfig> extractor7) {
        this.extractor1 = extractor1;
        this.driverProperties_parser = extractor1;
        this.extractor2 = extractor2;
        this.topics_parser = extractor2;
        this.extractor3 = extractor3;
        this.topicsPattern_parser = extractor3;
        this.partitions_parser = extractor2;
        this.extractor4 = extractor4;
        this.offset_parser = extractor4;
        this.extractor5 = extractor5;
        this.pollTimeout_parser = extractor5;
        this.backoffTimeout_parser = extractor5;
        this.partitionRefreshInterval_parser = extractor5;
        this.shutdownWait_parser = extractor5;
        this.extractor6 = extractor6;
        this.allowEmptyRecords_parser = extractor6;
        this.extractor7 = extractor7;
        this.telemetry_parser = extractor7;
    }

    public KafkaListenerConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        Properties driverProperties = this.parse_driverProperties(_config);
        List<String> topics = this.parse_topics(_config);
        Pattern topicsPattern = this.parse_topicsPattern(_config);
        List<String> partitions = this.parse_partitions(_config);
        Either<Duration, String> offset = this.parse_offset(_config);
        Duration pollTimeout = this.parse_pollTimeout(_config);
        Duration backoffTimeout = this.parse_backoffTimeout(_config);
        int threads = this.parse_threads(_config);
        Duration partitionRefreshInterval = this.parse_partitionRefreshInterval(_config);
        Duration shutdownWait = this.parse_shutdownWait(_config);
        boolean allowEmptyRecords = this.parse_allowEmptyRecords(_config);
        TelemetryConfig telemetry = this.parse_telemetry(_config);
        return new KafkaListenerConfig_Impl(driverProperties, topics, topicsPattern, partitions, offset, pollTimeout, backoffTimeout, threads, partitionRefreshInterval, shutdownWait, allowEmptyRecords, telemetry);
    }

    private Properties parse_driverProperties(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_driverProperties_path);
        Properties parsed = (Properties)this.driverProperties_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private List<String> parse_topics(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_topics_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (List)this.topics_parser.extract(value);
    }

    @Nullable
    private Pattern parse_topicsPattern(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_topicsPattern_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Pattern)this.topicsPattern_parser.extract(value);
    }

    @Nullable
    private List<String> parse_partitions(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_partitions_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (List)this.partitions_parser.extract(value);
    }

    private Either<Duration, String> parse_offset(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_offset_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Either<Duration, String> defaultValue = DEFAULTS.offset();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Either parsed = (Either)this.offset_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_pollTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_pollTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.pollTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.pollTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_backoffTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_backoffTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.backoffTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.backoffTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private int parse_threads(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_threads_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.threads();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private Duration parse_partitionRefreshInterval(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_partitionRefreshInterval_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.partitionRefreshInterval();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.partitionRefreshInterval_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_shutdownWait(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_shutdownWait_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.shutdownWait();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.shutdownWait_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private boolean parse_allowEmptyRecords(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_allowEmptyRecords_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.allowEmptyRecords();
            return defaultValue;
        }
        Boolean parsed = (Boolean)this.allowEmptyRecords_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        TelemetryConfig parsed = (TelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record KafkaListenerConfig_Impl(@Nonnull Properties driverProperties, List<String> topics, Pattern topicsPattern, List<String> partitions, @Nonnull Either<Duration, String> offset, @Nonnull Duration pollTimeout, @Nonnull Duration backoffTimeout, int threads, @Nonnull Duration partitionRefreshInterval, @Nonnull Duration shutdownWait, boolean allowEmptyRecords, @Nonnull TelemetryConfig telemetry) implements KafkaListenerConfig
    {
        public KafkaListenerConfig_Impl {
            Objects.requireNonNull(driverProperties);
            Objects.requireNonNull(offset);
            Objects.requireNonNull(pollTimeout);
            Objects.requireNonNull(backoffTimeout);
            Objects.requireNonNull(partitionRefreshInterval);
            Objects.requireNonNull(shutdownWait);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class KafkaListenerConfig_Defaults
    implements KafkaListenerConfig {
        @Override
        public Properties driverProperties() {
            return null;
        }

        @Override
        public List<String> topics() {
            return null;
        }

        @Override
        public Pattern topicsPattern() {
            return null;
        }

        @Override
        public List<String> partitions() {
            return null;
        }

        @Override
        public TelemetryConfig telemetry() {
            return null;
        }
    }
}

