/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.consumer.telemetry;

import jakarta.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerLogger;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerMetrics;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTelemetry;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTracer;

public class DefaultKafkaConsumerTelemetry<K, V>
implements KafkaConsumerTelemetry<K, V> {
    @Nullable
    private final KafkaConsumerLogger<K, V> logger;
    @Nullable
    private final KafkaConsumerTracer tracing;
    @Nullable
    private final KafkaConsumerMetrics metrics;
    private final String consumerName;

    public DefaultKafkaConsumerTelemetry(String consumerName, @Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerTracer tracing, @Nullable KafkaConsumerMetrics metrics) {
        this.consumerName = consumerName;
        this.logger = logger;
        this.tracing = tracing;
        this.metrics = metrics;
    }

    @Override
    public KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V> get(ConsumerRecords<K, V> records) {
        long start = System.nanoTime();
        if (this.metrics != null) {
            this.metrics.onRecordsReceived(records);
        }
        if (this.logger != null) {
            this.logger.logRecords(records);
        }
        KafkaConsumerTracer.KafkaConsumerRecordsSpan span = this.tracing == null ? null : this.tracing.get(records);
        return new DefaultKafkaConsumerRecordsTelemetryContext<K, V>(this.consumerName, records, this.logger, this.metrics, span, start);
    }

    @Override
    public void reportLag(TopicPartition partition, long lag) {
        if (this.metrics != null) {
            this.metrics.reportLag(partition, lag);
        }
    }

    private static final class DefaultKafkaConsumerRecordsTelemetryContext<K, V>
    implements KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V> {
        private final ConsumerRecords<K, V> records;
        @Nullable
        private final KafkaConsumerLogger<K, V> logger;
        @Nullable
        private final KafkaConsumerMetrics metrics;
        @Nullable
        private final KafkaConsumerTracer.KafkaConsumerRecordsSpan span;
        private final String consumerName;
        private final long start;

        public DefaultKafkaConsumerRecordsTelemetryContext(String consumerName, ConsumerRecords<K, V> records, @Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerMetrics metrics, @Nullable KafkaConsumerTracer.KafkaConsumerRecordsSpan span, long start) {
            this.consumerName = consumerName;
            this.records = records;
            this.logger = logger;
            this.metrics = metrics;
            this.span = span;
            this.start = start;
        }

        @Override
        public KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext<K, V> get(ConsumerRecord<K, V> record) {
            KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan;
            long recordStart = System.nanoTime();
            KafkaConsumerTracer.KafkaConsumerRecordSpan kafkaConsumerRecordSpan = recordSpan = this.span == null ? null : this.span.get(record);
            if (this.logger != null) {
                this.logger.logRecord(record);
            }
            return new DefaultKafkaConsumerRecordTelemetryContext<K, V>(record, recordStart, this.logger, this.metrics, recordSpan);
        }

        @Override
        public void close(@Nullable Throwable ex) {
            long duration = System.nanoTime() - this.start;
            if (this.span != null) {
                this.span.close(ex);
            }
            if (this.metrics != null) {
                this.metrics.onRecordsProcessed(this.consumerName, this.records, duration, ex);
            }
            if (this.logger != null) {
                this.logger.logRecordsProcessed(this.records, ex);
            }
        }
    }

    private static final class DefaultKafkaConsumerRecordTelemetryContext<K, V>
    implements KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext<K, V> {
        private final ConsumerRecord<K, V> record;
        private final long recordStart;
        @Nullable
        private final KafkaConsumerLogger<K, V> logger;
        @Nullable
        private final KafkaConsumerMetrics metrics;
        @Nullable
        private final KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan;

        public DefaultKafkaConsumerRecordTelemetryContext(ConsumerRecord<K, V> record, long recordStart, @Nullable KafkaConsumerLogger<K, V> logger, @Nullable KafkaConsumerMetrics metrics, @Nullable KafkaConsumerTracer.KafkaConsumerRecordSpan recordSpan) {
            this.record = record;
            this.recordStart = recordStart;
            this.logger = logger;
            this.metrics = metrics;
            this.recordSpan = recordSpan;
        }

        @Override
        public void close(@Nullable Throwable ex) {
            long duration = System.nanoTime() - this.recordStart;
            if (this.recordSpan != null) {
                this.recordSpan.close(ex);
            }
            if (this.metrics != null) {
                this.metrics.onRecordProcessed(this.record, duration, ex);
            }
            if (this.logger != null) {
                this.logger.logRecordProcessed(this.record, ex);
            }
        }
    }
}

