/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.consumer.containers;

import jakarta.annotation.Nonnull;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import ru.tinkoff.kora.kafka.common.consumer.containers.ConsumerRecordWrapper;

final class ConsumerRecordsWrapper<K, V>
extends ConsumerRecords<K, V> {
    private final ConsumerRecords<byte[], byte[]> realRecords;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final Map<ConsumerRecord<byte[], byte[]>, ConsumerRecordWrapper<K, V>> records = new IdentityHashMap<ConsumerRecord<byte[], byte[]>, ConsumerRecordWrapper<K, V>>();

    public ConsumerRecordsWrapper(ConsumerRecords<byte[], byte[]> realRecords, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        super(Map.of());
        this.realRecords = realRecords;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public List<ConsumerRecord<K, V>> records(TopicPartition partition) {
        return this.realRecords.records(partition).stream().map(this::wrapRecord).toList();
    }

    public Set<TopicPartition> partitions() {
        return this.realRecords.partitions();
    }

    @Nonnull
    public Iterator<ConsumerRecord<K, V>> iterator() {
        final Iterator real = this.realRecords.iterator();
        return new Iterator<ConsumerRecord<K, V>>(){

            @Override
            public boolean hasNext() {
                return real.hasNext();
            }

            @Override
            public ConsumerRecord<K, V> next() {
                return ConsumerRecordsWrapper.this.wrapRecord((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)real.next()));
            }
        };
    }

    public int count() {
        return this.realRecords.count();
    }

    public boolean isEmpty() {
        return this.realRecords.isEmpty();
    }

    private ConsumerRecord<K, V> wrapRecord(ConsumerRecord<byte[], byte[]> record) {
        return this.records.computeIfAbsent(record, r -> new ConsumerRecordWrapper<K, V>((ConsumerRecord<byte[], byte[]>)r, this.keyDeserializer, this.valueDeserializer));
    }
}

