/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.consumer.telemetry;

import jakarta.annotation.Nullable;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.DefaultKafkaConsumerTelemetry;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerLogger;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerLoggerFactory;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerMetrics;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerMetricsFactory;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTelemetry;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTelemetryFactory;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTracer;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultKafkaConsumerTelemetryFactory<K, V>
implements KafkaConsumerTelemetryFactory<K, V> {
    private final KafkaConsumerTelemetry<K, V> empty;
    @Nullable
    private final KafkaConsumerLoggerFactory<K, V> logger;
    @Nullable
    private final KafkaConsumerMetricsFactory metrics;
    @Nullable
    private final KafkaConsumerTracerFactory tracer;

    public DefaultKafkaConsumerTelemetryFactory(@Nullable KafkaConsumerLoggerFactory<K, V> logger, @Nullable KafkaConsumerMetricsFactory metrics, @Nullable KafkaConsumerTracerFactory tracer) {
        this.logger = logger;
        this.metrics = metrics;
        this.tracer = tracer;
        final KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext emptyRcdContext = ex -> {};
        final KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext emptyCtx = new KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V>(){

            @Override
            public KafkaConsumerTelemetry.KafkaConsumerRecordTelemetryContext<K, V> get(ConsumerRecord<K, V> record) {
                return emptyRcdContext;
            }

            @Override
            public void close(@Nullable Throwable ex) {
            }
        };
        this.empty = new KafkaConsumerTelemetry<K, V>(){

            @Override
            public KafkaConsumerTelemetry.KafkaConsumerRecordsTelemetryContext<K, V> get(ConsumerRecords<K, V> records) {
                return emptyCtx;
            }

            @Override
            public void reportLag(TopicPartition partition, long lag) {
            }
        };
    }

    @Override
    @Deprecated
    public KafkaConsumerTelemetry<K, V> get(Properties driverProperties, TelemetryConfig config) {
        KafkaConsumerTracer tracer;
        KafkaConsumerLogger<K, V> logger = this.logger == null ? null : this.logger.get(driverProperties, config.logging());
        KafkaConsumerMetrics metrics = this.metrics == null ? null : this.metrics.get(driverProperties, config.metrics());
        KafkaConsumerTracer kafkaConsumerTracer = tracer = this.tracer == null ? null : this.tracer.get(driverProperties, config.tracing());
        if (logger == null && metrics == null && tracer == null) {
            return this.empty;
        }
        return new DefaultKafkaConsumerTelemetry<K, V>("", logger, tracer, metrics);
    }

    @Override
    public KafkaConsumerTelemetry<K, V> get(String consumerName, Properties driverProperties, TelemetryConfig config) {
        KafkaConsumerTracer tracer;
        KafkaConsumerLogger<K, V> logger = this.logger == null ? null : this.logger.get(driverProperties, config.logging());
        KafkaConsumerMetrics metrics = this.metrics == null ? null : this.metrics.get(driverProperties, config.metrics());
        KafkaConsumerTracer kafkaConsumerTracer = tracer = this.tracer == null ? null : this.tracer.get(driverProperties, config.tracing());
        if (logger == null && metrics == null && tracer == null) {
            return this.empty;
        }
        return new DefaultKafkaConsumerTelemetry<K, V>(consumerName, logger, tracer, metrics);
    }
}

