/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.producer.telemetry;

import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerLogger;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerLoggerFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetricsFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTelemetry;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTelemetryFactory;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTracer;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class DefaultKafkaProducerTelemetryFactory
implements KafkaProducerTelemetryFactory {
    @Nullable
    private final KafkaProducerTracerFactory tracerFactory;
    @Nullable
    private final KafkaProducerLoggerFactory loggerFactory;
    @Nullable
    private final KafkaProducerMetricsFactory metricsFactory;

    public DefaultKafkaProducerTelemetryFactory(@Nullable KafkaProducerTracerFactory tracerFactory, @Nullable KafkaProducerLoggerFactory loggerFactory, @Nullable KafkaProducerMetricsFactory metricsFactory) {
        this.tracerFactory = tracerFactory;
        this.loggerFactory = loggerFactory;
        this.metricsFactory = metricsFactory;
    }

    @Override
    public KafkaProducerTelemetry get(TelemetryConfig config, Producer<?, ?> producer, Properties properties) {
        KafkaProducerTracer tracer = this.tracerFactory == null ? null : this.tracerFactory.get(config.tracing(), producer, properties);
        KafkaProducerLogger logger = this.loggerFactory == null ? null : this.loggerFactory.get(config.logging(), producer, properties);
        KafkaProducerMetrics metrics = this.metricsFactory == null ? null : this.metricsFactory.get(config.metrics(), producer, properties);
        return new DefaultKafkaProducerTelemetry(tracer, logger, metrics);
    }

    public static final class DefaultKafkaProducerTelemetry
    implements KafkaProducerTelemetry {
        @Nullable
        private final KafkaProducerTracer tracer;
        @Nullable
        private final KafkaProducerLogger logger;
        @Nullable
        private final KafkaProducerMetrics metrics;

        public DefaultKafkaProducerTelemetry(@Nullable KafkaProducerTracer tracer, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics metrics) {
            this.tracer = tracer;
            this.logger = logger;
            this.metrics = metrics;
        }

        @Override
        public void close() {
            AutoCloseable c;
            Object object = this.tracer;
            if (object instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = this.logger) instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = this.metrics) instanceof AutoCloseable) {
                c = (AutoCloseable)object;
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public KafkaProducerTelemetry.KafkaProducerTransactionTelemetryContext tx() {
            KafkaProducerMetrics.KafkaProducerTxMetrics metrics;
            KafkaProducerTracer.KafkaProducerTxSpan span = this.tracer == null ? null : this.tracer.tx();
            KafkaProducerMetrics.KafkaProducerTxMetrics kafkaProducerTxMetrics = metrics = this.metrics == null ? null : this.metrics.tx();
            if (this.logger != null) {
                this.logger.txBegin();
            }
            return new DefaultKafkaProducerTransactionTelemetryContext(span, this.logger, metrics);
        }

        @Override
        public KafkaProducerTelemetry.KafkaProducerRecordTelemetryContext record(ProducerRecord<?, ?> record) {
            if (this.logger != null) {
                this.logger.sendBegin(record);
            }
            KafkaProducerTracer.KafkaProducerRecordSpan span = this.tracer == null ? null : this.tracer.get(record);
            return new DefaultKafkaProducerRecordTelemetryContext(Either.left(record), span, this.logger, this.metrics);
        }

        @Override
        public KafkaProducerTelemetry.KafkaProducerRecordTelemetryContext record(KafkaProducerTelemetry.TelemetryProducerRecord<?, ?> record) {
            if (this.logger != null) {
                this.logger.sendBegin(record);
            }
            KafkaProducerTracer.KafkaProducerRecordSpan span = this.tracer == null ? null : this.tracer.get(record.producerRecord());
            return new DefaultKafkaProducerRecordTelemetryContext(Either.right(record), span, this.logger, this.metrics);
        }
    }

    private static final class DefaultKafkaProducerRecordTelemetryContext
    implements KafkaProducerTelemetry.KafkaProducerRecordTelemetryContext {
        private final KafkaProducerTracer.KafkaProducerRecordSpan span;
        private final KafkaProducerMetrics metrics;
        private final KafkaProducerLogger logger;
        private final Either<ProducerRecord<?, ?>, KafkaProducerTelemetry.TelemetryProducerRecord<?, ?>> record;
        private final Context ctx;
        private final long start;

        public DefaultKafkaProducerRecordTelemetryContext(Either<ProducerRecord<?, ?>, KafkaProducerTelemetry.TelemetryProducerRecord<?, ?>> record, @Nullable KafkaProducerTracer.KafkaProducerRecordSpan span, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics metrics) {
            this.span = span;
            this.logger = logger;
            this.record = record;
            this.metrics = metrics;
            this.ctx = Context.current().fork();
            this.start = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendEnd(Throwable e) {
            Context oldCtx = Context.current();
            try {
                this.ctx.inject();
                long duration = System.nanoTime() - this.start;
                if (this.span != null) {
                    this.span.close(e);
                }
                if (this.metrics != null) {
                    this.metrics.sendEnd(this.getKafkaProducerRecord(), duration, e);
                }
                if (this.logger != null) {
                    if (this.record.isRight()) {
                        this.logger.sendEnd((KafkaProducerTelemetry.TelemetryProducerRecord)this.record.right(), e);
                    } else {
                        this.logger.sendEnd((ProducerRecord)this.record.left(), e);
                    }
                }
            }
            finally {
                oldCtx.inject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendEnd(RecordMetadata metadata) {
            Context oldCtx = Context.current();
            try {
                this.ctx.inject();
                long duration = System.nanoTime() - this.start;
                if (this.span != null) {
                    this.span.close(metadata);
                }
                if (this.metrics != null) {
                    this.metrics.sendEnd(this.getKafkaProducerRecord(), duration, metadata);
                }
                if (this.logger != null) {
                    if (this.record.isRight()) {
                        this.logger.sendEnd((KafkaProducerTelemetry.TelemetryProducerRecord)this.record.right(), metadata);
                    } else {
                        this.logger.sendEnd(metadata);
                    }
                }
            }
            finally {
                oldCtx.inject();
            }
        }

        private ProducerRecord<?, ?> getKafkaProducerRecord() {
            return this.record.isLeft() ? (ProducerRecord<?, ?>)this.record.left() : ((KafkaProducerTelemetry.TelemetryProducerRecord)this.record.right()).producerRecord();
        }
    }

    private static final class DefaultKafkaProducerTransactionTelemetryContext
    implements KafkaProducerTelemetry.KafkaProducerTransactionTelemetryContext {
        @Nullable
        private final KafkaProducerTracer.KafkaProducerTxSpan span;
        @Nullable
        private final KafkaProducerLogger logger;
        @Nullable
        private final KafkaProducerMetrics.KafkaProducerTxMetrics metrics;

        private DefaultKafkaProducerTransactionTelemetryContext(@Nullable KafkaProducerTracer.KafkaProducerTxSpan span, @Nullable KafkaProducerLogger logger, @Nullable KafkaProducerMetrics.KafkaProducerTxMetrics metrics) {
            this.span = span;
            this.logger = logger;
            this.metrics = metrics;
        }

        @Override
        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
            if (this.logger != null) {
                this.logger.sendOffsetsToTransaction(offsets, groupMetadata);
            }
        }

        @Override
        public void commit() {
            if (this.metrics != null) {
                this.metrics.commit();
            }
            if (this.logger != null) {
                this.logger.txCommit();
            }
            if (this.span != null) {
                this.span.commit();
            }
        }

        @Override
        public void rollback(@Nullable Throwable e) {
            if (this.metrics != null) {
                this.metrics.rollback(e);
            }
            if (this.logger != null) {
                this.logger.txRollback(e);
            }
            if (this.span != null) {
                this.span.rollback(e);
            }
        }
    }
}

