/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.common.consumer.containers;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.serialization.Deserializer;
import ru.tinkoff.kora.kafka.common.consumer.containers.ConsumerRecordsWrapper;

public final class ConsumerWrapper<K, V>
implements Consumer<K, V> {
    private final Consumer<byte[], byte[]> realConsumer;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;

    public ConsumerWrapper(Consumer<byte[], byte[]> realConsumer, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this.realConsumer = realConsumer;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public Uuid clientInstanceId(Duration timeout) {
        return this.realConsumer.clientInstanceId(timeout);
    }

    public Set<TopicPartition> assignment() {
        return this.realConsumer.assignment();
    }

    public Set<String> subscription() {
        return this.realConsumer.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.realConsumer.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.realConsumer.subscribe(topics, callback);
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.realConsumer.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.realConsumer.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.realConsumer.subscribe(pattern);
    }

    public void unsubscribe() {
        this.realConsumer.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return new ConsumerRecordsWrapper<K, V>((ConsumerRecords<byte[], byte[]>)this.realConsumer.poll(timeout), this.keyDeserializer, this.valueDeserializer);
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        return new ConsumerRecordsWrapper<K, V>((ConsumerRecords<byte[], byte[]>)this.realConsumer.poll(timeout), this.keyDeserializer, this.valueDeserializer);
    }

    public void commitSync() {
        this.realConsumer.commitSync();
    }

    public void commitSync(Duration timeout) {
        this.realConsumer.commitSync(timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.realConsumer.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.realConsumer.commitSync(offsets, timeout);
    }

    public void commitAsync() {
        this.realConsumer.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.realConsumer.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.realConsumer.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.realConsumer.seek(partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.realConsumer.seek(partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.realConsumer.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.realConsumer.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.realConsumer.position(partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.realConsumer.position(partition, timeout);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.realConsumer.committed(partition);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.realConsumer.committed(partition, timeout);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.realConsumer.committed(partitions);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.realConsumer.committed(partitions, timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.realConsumer.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.realConsumer.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.realConsumer.partitionsFor(topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.realConsumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.realConsumer.listTopics(timeout);
    }

    public Set<TopicPartition> paused() {
        return this.realConsumer.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.realConsumer.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.realConsumer.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.realConsumer.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.realConsumer.offsetsForTimes(timestampsToSearch, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.realConsumer.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.realConsumer.beginningOffsets(partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.realConsumer.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.realConsumer.endOffsets(partitions, timeout);
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.realConsumer.currentLag(topicPartition);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.realConsumer.groupMetadata();
    }

    public void enforceRebalance() {
        this.realConsumer.enforceRebalance();
    }

    public void enforceRebalance(String reason) {
        this.realConsumer.enforceRebalance(reason);
    }

    public void close() {
        this.realConsumer.close();
    }

    public void close(Duration timeout) {
        this.realConsumer.close(timeout);
    }

    public void wakeup() {
        this.realConsumer.wakeup();
    }

    @Nonnull
    public Consumer<byte[], byte[]> unwrap() {
        return this.realConsumer;
    }

    public String toString() {
        return this.realConsumer.toString();
    }
}

