/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.logback;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.Status;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;
import ru.tinkoff.kora.logging.common.arg.StructuredArgumentWriter;
import ru.tinkoff.kora.logging.logback.KoraLoggingEvent;

public final class ConsoleTextRecordEncoder
implements Encoder<ILoggingEvent> {
    private final JsonFactory jsonFactory = new JsonFactory();
    private final CachingDateFormatter formatter = new CachingDateFormatter();
    private final Abbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(100);

    public byte[] encode(ILoggingEvent event) {
        try {
            return this.encode0(event);
        }
        catch (IOException e) {
            return "<error>".getBytes(StandardCharsets.UTF_8);
        }
    }

    private byte[] encode0(ILoggingEvent event) throws IOException {
        StructuredArgument structuredArgument;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        String levelSuffix = event.getLevel().levelStr.length() == 4 ? "  " : " ";
        w.append(this.formatter.format(event.getTimeStamp())).append(" ").append(event.getLevel().levelStr).append(levelSuffix).append("[").append(event.getThreadName()).append("] ").append(this.abbreviator.abbreviate(event.getLoggerName())).append(" - ").flush();
        if (event instanceof KoraLoggingEvent) {
            KoraLoggingEvent koraEvent = (KoraLoggingEvent)event;
            Map<String, StructuredArgumentWriter> mdc = koraEvent.koraMdc();
            for (Map.Entry<String, StructuredArgumentWriter> object : mdc.entrySet()) {
                String key = object.getKey();
                StructuredArgumentWriter value = object.getValue();
                w.append(key).append("=").flush();
                this.writeJson(baos, value);
                w.append(" ");
            }
            w.flush();
        }
        for (Map.Entry e : event.getMDCPropertyMap().entrySet()) {
            String key = (String)e.getKey();
            String string = (String)e.getValue();
            w.append(key).append("=").append(string).flush();
            w.append(" ");
        }
        w.append(event.getFormattedMessage()).flush();
        if (event.getMarkerList() != null) {
            for (Marker marker : event.getMarkerList()) {
                if (!(marker instanceof StructuredArgument)) continue;
                structuredArgument = (StructuredArgument)marker;
                w.append("\n").append("\t").append(structuredArgument.fieldName()).append("=").flush();
                this.writeJson(baos, (StructuredArgumentWriter)structuredArgument);
            }
        }
        if (event.getArgumentArray() != null) {
            for (Iterator iterator : event.getArgumentArray()) {
                if (!(iterator instanceof StructuredArgument)) continue;
                StructuredArgument structuredArgument2 = (StructuredArgument)iterator;
                w.append("\n").append("\t").append(structuredArgument2.fieldName()).append("=").flush();
                this.writeJson(baos, (StructuredArgumentWriter)structuredArgument2);
            }
        }
        if (event.getKeyValuePairs() != null) {
            for (KeyValuePair keyValue : event.getKeyValuePairs()) {
                Object object = keyValue.value;
                if (!(object instanceof StructuredArgumentWriter)) continue;
                structuredArgument = (StructuredArgumentWriter)object;
                w.append("\n").append("\t").append(keyValue.key).append("=").flush();
                this.writeJson(baos, (StructuredArgumentWriter)structuredArgument);
            }
        }
        w.append("\n");
        if (event.getThrowableProxy() != null) {
            w.append(ThrowableProxyUtil.asString((IThrowableProxy)event.getThrowableProxy()));
            w.append("\n");
        }
        w.flush();
        return baos.toByteArray();
    }

    private void writeJson(ByteArrayOutputStream b, StructuredArgumentWriter value) {
        try (JsonGenerator gen = this.jsonFactory.createGenerator((OutputStream)b);){
            value.writeTo(gen);
        }
        catch (IOException e) {
            try {
                b.write("<error>".getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] headerBytes() {
        return new byte[0];
    }

    public byte[] footerBytes() {
        return new byte[0];
    }

    public void setContext(Context context) {
    }

    public Context getContext() {
        return null;
    }

    public void addStatus(Status status) {
    }

    public void addInfo(String msg) {
    }

    public void addInfo(String msg, Throwable ex) {
    }

    public void addWarn(String msg) {
    }

    public void addWarn(String msg, Throwable ex) {
    }

    public void addError(String msg) {
    }

    public void addError(String msg, Throwable ex) {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    public static class CachingDateFormatter {
        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        private long lastTimestamp = -1L;
        private String cachedStr = null;

        public final String format(long now) {
            if (now != this.lastTimestamp) {
                this.lastTimestamp = now;
                this.cachedStr = this.formatter.format(Instant.ofEpochMilli(now).atZone(ZoneOffset.UTC));
            }
            return this.cachedStr;
        }
    }
}

