/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.netty.common;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import jakarta.annotation.Nullable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.application.graph.LifecycleWrapper;
import ru.tinkoff.kora.common.Tag;

public interface NettyCommonModule {
    default public LifecycleWrapper<EventLoopGroup> nettyEventLoopGroupLifecycle(@Tag(value={NettyCommonModule.class}) @Nullable ThreadFactory threadFactory, @Tag(value={NettyCommonModule.class}) @Nullable Integer size) {
        return new LifecycleWrapper((Object)NettyCommonModule.eventLoopGroup(threadFactory, size), elg -> {}, elg -> elg.shutdownGracefully(1L, 1L, TimeUnit.MILLISECONDS).get());
    }

    @Tag(value={BossLoopGroup.class})
    default public LifecycleWrapper<EventLoopGroup> nettyEventBossLoopGroupLifecycle(@Tag(value={NettyCommonModule.class}) @Nullable ThreadFactory threadFactory) {
        return new LifecycleWrapper((Object)NettyCommonModule.eventLoopGroup(threadFactory, 1), elg -> {}, elg -> elg.shutdownGracefully(1L, 1L, TimeUnit.MILLISECONDS).get());
    }

    private static EventLoopGroup eventLoopGroup(@Nullable ThreadFactory threadFactory, @Nullable Integer size) {
        if (size == null) {
            size = NettyRuntime.availableProcessors() * 2;
        }
        if (NettyCommonModule.isClassPresent("io.netty.channel.epoll.Epoll") && Epoll.isAvailable()) {
            return new EpollEventLoopGroup(size.intValue(), threadFactory);
        }
        if (NettyCommonModule.isClassPresent("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(size.intValue(), threadFactory);
        }
        return new NioEventLoopGroup(size.intValue(), threadFactory);
    }

    private static boolean isClassPresent(String className) {
        try {
            return NettyCommonModule.class.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<? extends Channel> channelType() {
        if (NettyCommonModule.isClassPresent("io.netty.channel.epoll.Epoll") && Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        if (NettyCommonModule.isClassPresent("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable()) {
            return KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerChannel> serverChannelType() {
        if (NettyCommonModule.isClassPresent("io.netty.channel.epoll.Epoll") && Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        if (NettyCommonModule.isClassPresent("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable()) {
            return KQueueServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static final class BossLoopGroup {
    }
}

