/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.netty.common;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.annotation.Nullable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.application.graph.LifecycleWrapper;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.netty.common.NettyChannelFactory;
import ru.tinkoff.kora.netty.common.NettyTransportConfig;

public interface NettyCommonModule {
    default public NettyTransportConfig nettyTransportConfig(Config config, ConfigValueExtractor<NettyTransportConfig> extractor) {
        return (NettyTransportConfig)extractor.extract(config.get("netty"));
    }

    @Tag(value={WorkerLoopGroup.class})
    default public LifecycleWrapper<EventLoopGroup> nettyEventLoopGroupLifecycle(@Tag(value={NettyCommonModule.class}) @Nullable ThreadFactory threadFactory, NettyTransportConfig nettyTransportConfig) {
        return new LifecycleWrapper((Object)NettyCommonModule.eventLoopGroup(threadFactory, nettyTransportConfig.threads(), nettyTransportConfig.transport()), elg -> {}, elg -> elg.shutdownGracefully(1L, 1L, TimeUnit.MILLISECONDS).get());
    }

    @Tag(value={BossLoopGroup.class})
    default public LifecycleWrapper<EventLoopGroup> nettyEventBossLoopGroupLifecycle(@Tag(value={NettyCommonModule.class}) @Nullable ThreadFactory threadFactory, NettyTransportConfig nettyTransportConfig) {
        return new LifecycleWrapper((Object)NettyCommonModule.eventLoopGroup(threadFactory, 1, nettyTransportConfig.transport()), elg -> {}, elg -> elg.shutdownGracefully(1L, 1L, TimeUnit.MILLISECONDS).get());
    }

    private static EventLoopGroup eventLoopGroup(@Nullable ThreadFactory threadFactory, Integer size, @Nullable NettyTransportConfig.EventLoop preferredEventLoop) {
        if (preferredEventLoop != null) {
            if (NettyTransportConfig.EventLoop.EPOLL == preferredEventLoop && NettyCommonModule.isEpollAvailable()) {
                return new EpollEventLoopGroup(size.intValue(), threadFactory);
            }
            if (NettyTransportConfig.EventLoop.KQUEUE == preferredEventLoop && NettyCommonModule.isKQueueAvailable()) {
                return new KQueueEventLoopGroup(size.intValue(), threadFactory);
            }
            if (NettyTransportConfig.EventLoop.NIO == preferredEventLoop) {
                return new NioEventLoopGroup(size.intValue(), threadFactory);
            }
        }
        if (NettyCommonModule.isEpollAvailable()) {
            return new EpollEventLoopGroup(size.intValue(), threadFactory);
        }
        if (NettyCommonModule.isKQueueAvailable()) {
            return new KQueueEventLoopGroup(size.intValue(), threadFactory);
        }
        return new NioEventLoopGroup(size.intValue(), threadFactory);
    }

    default public NettyChannelFactory nettyChannelFactory(NettyTransportConfig nettyConfig) {
        if (nettyConfig.transport() != null) {
            if (NettyTransportConfig.EventLoop.EPOLL == nettyConfig.transport() && NettyCommonModule.isEpollAvailable()) {
                return NettyCommonModule.getEpollChannelFactory();
            }
            if (NettyTransportConfig.EventLoop.KQUEUE == nettyConfig.transport() && NettyCommonModule.isKQueueAvailable()) {
                return NettyCommonModule.getKQueueChannelFactory();
            }
            if (NettyTransportConfig.EventLoop.NIO == nettyConfig.transport()) {
                return NettyCommonModule.getNioChannelFactory();
            }
        }
        if (NettyCommonModule.isEpollAvailable()) {
            return NettyCommonModule.getEpollChannelFactory();
        }
        if (NettyCommonModule.isKQueueAvailable()) {
            return NettyCommonModule.getKQueueChannelFactory();
        }
        return NettyCommonModule.getNioChannelFactory();
    }

    private static NettyChannelFactory getNioChannelFactory() {
        return new NettyChannelFactory(){

            @Override
            public ChannelFactory<Channel> getClientFactory(boolean domainSocket) {
                return NioSocketChannel::new;
            }

            @Override
            public ChannelFactory<ServerChannel> getServerFactory(boolean domainSocket) {
                return NioServerSocketChannel::new;
            }
        };
    }

    private static NettyChannelFactory getEpollChannelFactory() {
        return new NettyChannelFactory(){

            @Override
            public ChannelFactory<Channel> getClientFactory(boolean domainSocket) {
                if (domainSocket) {
                    return EpollDomainSocketChannel::new;
                }
                return EpollSocketChannel::new;
            }

            @Override
            public ChannelFactory<ServerChannel> getServerFactory(boolean domainSocket) {
                if (domainSocket) {
                    return EpollServerDomainSocketChannel::new;
                }
                return EpollServerSocketChannel::new;
            }
        };
    }

    private static NettyChannelFactory getKQueueChannelFactory() {
        return new NettyChannelFactory(){

            @Override
            public ChannelFactory<Channel> getClientFactory(boolean domainSocket) {
                if (domainSocket) {
                    return KQueueDomainSocketChannel::new;
                }
                return KQueueSocketChannel::new;
            }

            @Override
            public ChannelFactory<ServerChannel> getServerFactory(boolean domainSocket) {
                if (domainSocket) {
                    return KQueueServerDomainSocketChannel::new;
                }
                return KQueueServerSocketChannel::new;
            }
        };
    }

    private static boolean isEpollAvailable() {
        return NettyCommonModule.isClassPresent("io.netty.channel.epoll.Epoll") && Epoll.isAvailable();
    }

    private static boolean isKQueueAvailable() {
        return NettyCommonModule.isClassPresent("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable();
    }

    private static boolean isClassPresent(String className) {
        try {
            return NettyCommonModule.class.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final class WorkerLoopGroup {
    }

    public static final class BossLoopGroup {
    }
}

