/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;
import ru.tinkoff.kora.openapi.management.ResourceUtils;

final class SwaggerUIHttpServerHandler
implements HttpServerRequestHandler.HandlerFunction {
    private static final String FILE_PATH = "kora/openapi/management/swagger-ui/index.html";
    private static final String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    private final byte[] swaggerui;

    SwaggerUIHttpServerHandler(OpenApiManagementConfig config) {
        this.swaggerui = SwaggerUIHttpServerHandler.loadSwagger(config);
    }

    public CompletionStage<HttpServerResponse> apply(Context context, HttpServerRequest request) throws Exception {
        return CompletableFuture.completedFuture(HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)HTML_CONTENT_TYPE, (byte[])this.swaggerui)));
    }

    private static byte[] loadSwagger(OpenApiManagementConfig config) {
        return ResourceUtils.getFileAsString(FILE_PATH).map(file -> {
            String tagSwagger = "${swaggerUIPath}";
            int ri = file.lastIndexOf(tagSwagger);
            String result = file.substring(0, ri) + config.swaggerui().endpoint() + file.substring(ri + tagSwagger.length());
            String tagOpenapi = "${openapiPath}";
            int oi = result.lastIndexOf(tagOpenapi);
            result = result.substring(0, oi) + config.endpoint() + result.substring(oi + tagOpenapi.length());
            return result;
        }).map(file -> file.getBytes(StandardCharsets.UTF_8)).orElseThrow(() -> HttpServerResponseException.of((int)404, (String)"Swagger UI file not found"));
    }
}

