/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandlerImpl;
import ru.tinkoff.kora.openapi.management.OpenApiHttpServerHandler;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;
import ru.tinkoff.kora.openapi.management.RapidocHttpServerHandler;
import ru.tinkoff.kora.openapi.management.SwaggerUIHttpServerHandler;

public interface OpenApiManagementModule {
    default public OpenApiManagementConfig openApiManagementConfig(Config config, ConfigValueExtractor<OpenApiManagementConfig> extractor) {
        return (OpenApiManagementConfig)extractor.extract(config.get("openapi.management"));
    }

    default public HttpServerRequestHandler openApiManagementController(OpenApiManagementConfig config) {
        OpenApiHttpServerHandler handler = new OpenApiHttpServerHandler(config.file(), f -> f);
        Object path = config.file().size() == 1 ? config.endpoint() : config.endpoint() + "/{file}";
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)path, (HttpServerRequestHandler.HandlerFunction)handler, (boolean)config.enabled());
    }

    default public HttpServerRequestHandler swaggerUIManagementController(OpenApiManagementConfig config) {
        boolean enabled = config.swaggerui() != null && config.swaggerui().enabled();
        SwaggerUIHttpServerHandler handler = new SwaggerUIHttpServerHandler(config.endpoint(), config.swaggerui().endpoint(), config.file());
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.swaggerui().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler, (boolean)enabled);
    }

    default public HttpServerRequestHandler rapidocManagementController(OpenApiManagementConfig config) {
        boolean enabled = config.rapidoc() != null && config.rapidoc().enabled();
        RapidocHttpServerHandler handler = new RapidocHttpServerHandler(config.endpoint(), config.rapidoc().endpoint(), config.file());
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.rapidoc().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler, (boolean)enabled);
    }
}

