/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.openapi.management.ResourceUtils;

public final class OpenApiHttpServerHandler
implements HttpServerRequestHandler.HandlerFunction {
    private final Map<String, OpenapiFile> openapiFiles = new ConcurrentHashMap<String, OpenapiFile>();
    private final Function<byte[], byte[]> openApiMapper;

    public OpenApiHttpServerHandler(List<String> openapiFiles, Function<byte[], byte[]> openApiMapper) {
        this.openApiMapper = openApiMapper;
        for (String filePath : openapiFiles) {
            String contentType = filePath.endsWith(".json") ? "text/json; charset=utf-8" : "text/x-yaml; charset=utf-8";
            String fileName = ResourceUtils.getFileName(filePath);
            this.openapiFiles.put(fileName, new OpenapiFile(fileName, filePath, contentType, new AtomicReference<byte[]>()));
        }
    }

    public CompletionStage<HttpServerResponse> apply(Context context, HttpServerRequest request) {
        String fileName;
        String string = fileName = this.openapiFiles.size() == 1 ? this.openapiFiles.keySet().iterator().next() : (String)request.pathParams().get("file");
        if (fileName == null || fileName.isEmpty()) {
            return CompletableFuture.completedFuture(HttpServerResponse.of((int)400, (HttpBodyOutput)HttpBody.plaintext((String)"OpenAPI file not specified")));
        }
        OpenapiFile openapiFile = this.openapiFiles.get(fileName);
        if (openapiFile == null) {
            return CompletableFuture.completedFuture(HttpServerResponse.of((int)404, (HttpBodyOutput)HttpBody.plaintext((String)("OpenAPI file not registered: " + fileName))));
        }
        byte[] bytes = openapiFile.content().get();
        if (bytes != null) {
            return CompletableFuture.completedFuture(HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)openapiFile.contentType(), (byte[])bytes)));
        }
        return CompletableFuture.supplyAsync(() -> {
            byte[] fileContent = this.loadOpenapi(openapiFile.filePath());
            byte[] fileResult = this.openApiMapper.apply(fileContent);
            openapiFile.content().set(fileResult);
            return HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)openapiFile.contentType(), (byte[])fileResult));
        });
    }

    private byte[] loadOpenapi(String filePath) {
        try {
            InputStream openapiAsStream = ResourceUtils.getFileAsStream(filePath);
            if (openapiAsStream == null) {
                throw HttpServerResponseException.of((int)404, (String)("OpenAPI file not found while reading: " + filePath));
            }
            return openapiAsStream.readAllBytes();
        }
        catch (IOException e) {
            throw HttpServerResponseException.of((int)500, (String)("Can't read OpenAPI file: " + filePath));
        }
    }

    record OpenapiFile(String fileName, String filePath, String contentType, AtomicReference<byte[]> content) {
    }
}

