/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $OpenApiManagementConfig_ConfigValueExtractor
implements ConfigValueExtractor<OpenApiManagementConfig> {
    public static final OpenApiManagementConfig_Defaults DEFAULTS = new OpenApiManagementConfig_Defaults();
    private static final PathElement.Key _file_path = PathElement.get((String)"file");
    private static final PathElement.Key _enabled_path = PathElement.get((String)"enabled");
    private static final PathElement.Key _endpoint_path = PathElement.get((String)"endpoint");
    private static final PathElement.Key _swaggerui_path = PathElement.get((String)"swaggerui");
    private static final PathElement.Key _rapidoc_path = PathElement.get((String)"rapidoc");
    private final ConfigValueExtractor<Boolean> extractor1;
    private final ConfigValueExtractor<Boolean> enabled_parser;
    private final ConfigValueExtractor<OpenApiManagementConfig.SwaggerUIConfig> extractor2;
    private final ConfigValueExtractor<OpenApiManagementConfig.SwaggerUIConfig> swaggerui_parser;
    private final ConfigValueExtractor<OpenApiManagementConfig.RapidocConfig> extractor3;
    private final ConfigValueExtractor<OpenApiManagementConfig.RapidocConfig> rapidoc_parser;

    public $OpenApiManagementConfig_ConfigValueExtractor(ConfigValueExtractor<Boolean> extractor1, ConfigValueExtractor<OpenApiManagementConfig.SwaggerUIConfig> extractor2, ConfigValueExtractor<OpenApiManagementConfig.RapidocConfig> extractor3) {
        this.extractor1 = extractor1;
        this.enabled_parser = extractor1;
        this.extractor2 = extractor2;
        this.swaggerui_parser = extractor2;
        this.extractor3 = extractor3;
        this.rapidoc_parser = extractor3;
    }

    public OpenApiManagementConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String file = this.parse_file(_config);
        boolean enabled = this.parse_enabled(_config);
        String endpoint = this.parse_endpoint(_config);
        OpenApiManagementConfig.SwaggerUIConfig swaggerui = this.parse_swaggerui(_config);
        OpenApiManagementConfig.RapidocConfig rapidoc = this.parse_rapidoc(_config);
        return new OpenApiManagementConfig_Impl(file, enabled, endpoint, swaggerui, rapidoc);
    }

    private String parse_file(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_file_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private boolean parse_enabled(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_enabled_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.enabled();
            return defaultValue;
        }
        Boolean parsed = (Boolean)this.enabled_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private String parse_endpoint(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_endpoint_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.endpoint();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    @Nullable
    private OpenApiManagementConfig.SwaggerUIConfig parse_swaggerui(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_swaggerui_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (OpenApiManagementConfig.SwaggerUIConfig)this.swaggerui_parser.extract(value);
    }

    @Nullable
    private OpenApiManagementConfig.RapidocConfig parse_rapidoc(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_rapidoc_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (OpenApiManagementConfig.RapidocConfig)this.rapidoc_parser.extract(value);
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record OpenApiManagementConfig_Impl(@Nonnull String file, boolean enabled, @Nonnull String endpoint, OpenApiManagementConfig.SwaggerUIConfig swaggerui, OpenApiManagementConfig.RapidocConfig rapidoc) implements OpenApiManagementConfig
    {
        public OpenApiManagementConfig_Impl {
            Objects.requireNonNull(file);
            Objects.requireNonNull(endpoint);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class OpenApiManagementConfig_Defaults
    implements OpenApiManagementConfig {
        @Override
        public String file() {
            return null;
        }

        @Override
        public OpenApiManagementConfig.SwaggerUIConfig swaggerui() {
            return null;
        }

        @Override
        public OpenApiManagementConfig.RapidocConfig rapidoc() {
            return null;
        }
    }
}

