/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.common;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import jakarta.annotation.Nullable;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.logging.common.MDC;

public class OpentelemetryContext {
    private static final Context.Key<OpentelemetryContext> KEY = new Context.Key<OpentelemetryContext>(){

        protected OpentelemetryContext copy(OpentelemetryContext object) {
            return new OpentelemetryContext(object.context);
        }
    };
    private final Context context;

    public OpentelemetryContext() {
        this(Context.root());
    }

    public OpentelemetryContext(Context ctx) {
        this.context = ctx;
    }

    public static OpentelemetryContext get(ru.tinkoff.kora.common.Context ctx) {
        OpentelemetryContext tctx = (OpentelemetryContext)ctx.get(KEY);
        if (tctx != null) {
            return tctx;
        }
        return (OpentelemetryContext)ctx.set(KEY, (Object)new OpentelemetryContext());
    }

    public static void set(ru.tinkoff.kora.common.Context ctx, @Nullable OpentelemetryContext ot) {
        Span span;
        ctx.set(KEY, (Object)ot);
        MDC mdc = MDC.get();
        Span span2 = span = ot != null ? Span.fromContextOrNull((Context)ot.getContext()) : null;
        if (span == null) {
            mdc.remove0("traceId");
            mdc.remove0("spanId");
        } else {
            SpanContext spanContext = span.getSpanContext();
            mdc.put0("traceId", generator -> generator.writeString(spanContext.getTraceId()));
            mdc.put0("spanId", generator -> generator.writeString(spanContext.getSpanId()));
        }
    }

    public OpentelemetryContext add(ImplicitContextKeyed value) {
        return new OpentelemetryContext(value.storeInContext(this.context));
    }

    public Context getContext() {
        return this.context;
    }
}

