/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.tracing;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.LifecycleWrapper;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.opentelemetry.module.OpentelemetryModule;
import ru.tinkoff.kora.opentelemetry.tracing.OpentelemetryResourceConfig;

public interface OpentelemetryTracingModule
extends OpentelemetryModule {
    default public OpentelemetryResourceConfig opentelemetryResourceConfig(Config config, ConfigValueExtractor<OpentelemetryResourceConfig> extractor) {
        return (OpentelemetryResourceConfig)extractor.extract(config.get("tracing"));
    }

    default public Resource opentelemetryTracingResource(OpentelemetryResourceConfig config) {
        ResourceBuilder resource = Resource.builder();
        for (Map.Entry<String, String> attribute : config.attributes().entrySet()) {
            resource.put(attribute.getKey(), attribute.getValue());
        }
        return resource.build();
    }

    @DefaultComponent
    default public IdGenerator opentelemetryTracingIdGenerator() {
        return IdGenerator.random();
    }

    @DefaultComponent
    default public Supplier<SpanLimits> opentelemetryTracingSpanLimitsSupplier() {
        return SpanLimits::getDefault;
    }

    @DefaultComponent
    default public Sampler opentelemetryTracingSampler() {
        return Sampler.parentBased((Sampler)Sampler.alwaysOn());
    }

    default public LifecycleWrapper<SdkTracerProvider> opentelemetryTracerProvider(IdGenerator idGenerator, Supplier<SpanLimits> spanLimits, Sampler sampler, @Nullable SpanProcessor spanProcessor, Resource resource) {
        if (spanProcessor == null) {
            spanProcessor = SpanProcessor.composite((SpanProcessor[])new SpanProcessor[0]);
        }
        return new LifecycleWrapper((Object)SdkTracerProvider.builder().setIdGenerator(idGenerator).setSpanLimits(spanLimits).setSampler(sampler).addSpanProcessor(spanProcessor).setResource(resource).build(), p -> Mono.empty(), p -> Mono.fromRunnable(() -> ((SdkTracerProvider)p).close()));
    }

    default public Tracer opentelemetryTracer(TracerProvider tracerProvider) {
        return tracerProvider.tracerBuilder("kora").build();
    }
}

