/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.circuitbreaker.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerFailurePredicate;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerManager;
import ru.tinkoff.kora.resilient.circuitbreaker.impl.FastCircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.impl.FastCircuitBreakerConfig;
import ru.tinkoff.kora.resilient.circuitbreaker.telemetry.CircuitBreakerMetrics;

final class FastCircuitBreakerManager
implements CircuitBreakerManager {
    private static final Logger logger = LoggerFactory.getLogger(FastCircuitBreakerManager.class);
    private final Map<String, CircuitBreaker> circuitBreakerMap = new ConcurrentHashMap<String, CircuitBreaker>();
    private final FastCircuitBreakerConfig config;
    private final List<CircuitBreakerFailurePredicate> failurePredicates;
    private final CircuitBreakerMetrics metrics;

    FastCircuitBreakerManager(FastCircuitBreakerConfig config, List<CircuitBreakerFailurePredicate> failurePredicates, CircuitBreakerMetrics metrics) {
        this.config = config;
        this.failurePredicates = failurePredicates;
        this.metrics = metrics;
    }

    @Override
    @Nonnull
    public CircuitBreaker get(@Nonnull String name) {
        return this.circuitBreakerMap.computeIfAbsent(name, k -> {
            FastCircuitBreakerConfig.NamedConfig config = this.config.getNamedConfig(name);
            CircuitBreakerFailurePredicate failurePredicate = this.getFailurePredicate(config);
            logger.debug("Creating CircuitBreaker named '{}' with failure predicate '{}' and config {}", new Object[]{name, failurePredicate.name(), config});
            return new FastCircuitBreaker(name, config, failurePredicate, this.metrics);
        });
    }

    private CircuitBreakerFailurePredicate getFailurePredicate(FastCircuitBreakerConfig.NamedConfig config) {
        return this.failurePredicates.stream().filter(p -> p.name().equals(config.failurePredicateName())).findFirst().orElseThrow(() -> new IllegalArgumentException("FailurePredicateClassName " + config.failurePredicateName() + " is not present as bean, please declare it as bean"));
    }
}

