/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.circuitbreaker.simple;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.tinkoff.kora.resilient.circuitbreaker.simple.FastCircuitBreakerFailurePredicate;

public record FastCircuitBreakerConfig(@Nullable Map<String, NamedConfig> circuitbreaker) {
    public static final String DEFAULT = "default";

    public NamedConfig getNamedConfig(@Nonnull String name) {
        if (this.circuitbreaker == null) {
            throw new IllegalStateException("CircuitBreaker no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig defaultConfig = this.circuitbreaker.get(DEFAULT);
        NamedConfig namedConfig = this.circuitbreaker.getOrDefault(name, defaultConfig);
        if (namedConfig == null) {
            throw new IllegalStateException("CircuitBreaker no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig mergedConfig = FastCircuitBreakerConfig.merge(namedConfig, defaultConfig);
        if (mergedConfig.failureRateThreshold == null) {
            throw new IllegalStateException("CircuitBreaker 'failureRateThreshold' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.waitDurationInOpenState == null) {
            throw new IllegalStateException("CircuitBreaker 'waitDurationInOpenState' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.permittedCallsInHalfOpenState == null) {
            throw new IllegalStateException("CircuitBreaker 'permittedCallsInHalfOpenState' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.slidingWindowSize == null) {
            throw new IllegalStateException("CircuitBreaker 'slidingWindowSize' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.minimumRequiredCalls == null) {
            throw new IllegalStateException("CircuitBreaker 'minimumRequiredCalls' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.minimumRequiredCalls < 1L) {
            throw new IllegalArgumentException("CircuitBreaker '" + name + "' minimumRequiredCalls can't be negative, but was " + mergedConfig.minimumRequiredCalls);
        }
        if (mergedConfig.slidingWindowSize < 1L) {
            throw new IllegalArgumentException("CircuitBreaker '" + name + "' slidingWindowSize can't be negative, but was " + mergedConfig.slidingWindowSize);
        }
        if (mergedConfig.minimumRequiredCalls > mergedConfig.slidingWindowSize) {
            throw new IllegalArgumentException("CircuitBreaker '" + name + "' minimumRequiredCalls was " + mergedConfig.minimumRequiredCalls + " can't be more than slidingWindowSize which is " + mergedConfig.slidingWindowSize);
        }
        if (mergedConfig.failureRateThreshold > 100 || mergedConfig.failureRateThreshold < 1) {
            throw new IllegalArgumentException("CircuitBreaker '" + name + "' failureRateThreshold is percentage and must be in range 1 to 100, but was " + mergedConfig.failureRateThreshold);
        }
        return mergedConfig;
    }

    private static NamedConfig merge(NamedConfig namedConfig, NamedConfig defaultConfig) {
        if (defaultConfig == null) {
            return namedConfig;
        }
        return new NamedConfig(namedConfig.failureRateThreshold == null ? defaultConfig.failureRateThreshold : namedConfig.failureRateThreshold, namedConfig.waitDurationInOpenState == null ? defaultConfig.waitDurationInOpenState : namedConfig.waitDurationInOpenState, namedConfig.permittedCallsInHalfOpenState == null ? defaultConfig.permittedCallsInHalfOpenState : namedConfig.permittedCallsInHalfOpenState, namedConfig.slidingWindowSize == null ? defaultConfig.slidingWindowSize : namedConfig.slidingWindowSize, namedConfig.minimumRequiredCalls == null ? defaultConfig.minimumRequiredCalls : namedConfig.minimumRequiredCalls, namedConfig.failurePredicateName == null ? defaultConfig.failurePredicateName : namedConfig.failurePredicateName);
    }

    public record NamedConfig(@Nullable Integer failureRateThreshold, @Nullable Duration waitDurationInOpenState, @Nullable Integer permittedCallsInHalfOpenState, @Nullable Long slidingWindowSize, @Nullable Long minimumRequiredCalls, @Nullable String failurePredicateName) {
        public NamedConfig(@Nullable Integer failureRateThreshold, @Nullable Duration waitDurationInOpenState, @Nullable Integer permittedCallsInHalfOpenState, @Nullable Long slidingWindowSize, @Nullable Long minimumRequiredCalls, @Nullable String failurePredicateName) {
            this.failureRateThreshold = failureRateThreshold;
            this.waitDurationInOpenState = waitDurationInOpenState;
            this.permittedCallsInHalfOpenState = permittedCallsInHalfOpenState;
            this.slidingWindowSize = slidingWindowSize;
            this.minimumRequiredCalls = minimumRequiredCalls;
            this.failurePredicateName = failurePredicateName == null ? FastCircuitBreakerFailurePredicate.class.getCanonicalName() : failurePredicateName;
        }

        public Clock clock() {
            return Clock.systemDefaultZone();
        }
    }
}

