/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.circuitbreaker.simple;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.circuitbreaker.CallNotPermittedException;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerFailurePredicate;
import ru.tinkoff.kora.resilient.circuitbreaker.simple.SimpleCircuitBreakerConfig;
import ru.tinkoff.kora.resilient.circuitbreaker.telemetry.CircuitBreakerMetrics;

record SimpleCircuitBreaker(AtomicLong state, String name, SimpleCircuitBreakerConfig.NamedConfig config, CircuitBreakerFailurePredicate failurePredicate, CircuitBreakerMetrics metrics, long waitDurationInOpenStateInMillis, Clock clock) implements CircuitBreaker
{
    private static final Logger logger = LoggerFactory.getLogger(SimpleCircuitBreaker.class);
    private static final long CLOSED_COUNTER_MASK = Integer.MAX_VALUE;
    private static final long CLOSED_STATE = Long.MIN_VALUE;
    private static final long HALF_OPEN_COUNTER_MASK = 65535L;
    private static final long HALF_OPEN_STATE = 0x4000000000000000L;
    private static final long HALF_OPEN_INCREMENT_SUCCESS = 65536L;
    private static final long HALF_OPEN_INCREMENT_ERROR = 0x100000000L;
    private static final long OPEN_STATE = 0L;
    private static final long COUNTER_INC = 1L;
    private static final long ERR_COUNTER_INC = 0x80000000L;
    private static final long BOTH_COUNTERS_INC = 0x80000001L;

    SimpleCircuitBreaker(String name, SimpleCircuitBreakerConfig.NamedConfig config, CircuitBreakerFailurePredicate failurePredicate, CircuitBreakerMetrics metrics) {
        this(new AtomicLong(Long.MIN_VALUE), name, config, failurePredicate, metrics, config.waitDurationInOpenState().toMillis(), config.clock());
        this.metrics.recordState(name, CircuitBreaker.State.CLOSED);
    }

    @Nonnull
    CircuitBreaker.State getState() {
        return this.getState(this.state.get());
    }

    @Override
    public <T> T accept(@Nonnull Supplier<T> callable) {
        return this.internalAccept(callable, null);
    }

    @Override
    public <T> T accept(@Nonnull Supplier<T> callable, @Nonnull Supplier<T> fallback) {
        return this.internalAccept(callable, fallback);
    }

    private <T> T internalAccept(@Nonnull Supplier<T> supplier, Supplier<T> fallback) {
        try {
            this.acquire();
            T t = supplier.get();
            this.releaseOnSuccess();
            return t;
        }
        catch (CallNotPermittedException e) {
            if (fallback == null) {
                throw e;
            }
            return fallback.get();
        }
        catch (Exception e) {
            this.releaseOnError(e);
            throw e;
        }
    }

    private CircuitBreaker.State getState(long value) {
        return switch ((int)(value >> 62 & 3L)) {
            case 0 -> CircuitBreaker.State.OPEN;
            case 1 -> CircuitBreaker.State.HALF_OPEN;
            default -> CircuitBreaker.State.CLOSED;
        };
    }

    private int countClosedErrors(long value) {
        return (int)(value >> 31 & Integer.MAX_VALUE);
    }

    private int countClosedTotal(long value) {
        return (int)(value & Integer.MAX_VALUE);
    }

    private short countHalfOpenSuccess(long value) {
        return (short)(value >> 16 & 0xFFFFL);
    }

    private short countHalfOpenError(long value) {
        return (short)(value >> 32 & 0xFFFFL);
    }

    private short countHalfOpenAcquired(long value) {
        return (short)(value & 0xFFFFL);
    }

    private long getOpenState() {
        return this.clock.millis();
    }

    void onStateChange(@Nonnull CircuitBreaker.State prevState, @Nonnull CircuitBreaker.State newState) {
        logger.debug("CircuitBreaker '{}' switched from {} to {}", new Object[]{this.name, prevState, newState});
        this.metrics.recordState(this.name, newState);
    }

    @Override
    public void acquire() throws CallNotPermittedException {
        if (!this.tryAcquire()) {
            throw new CallNotPermittedException(this.getState(this.state.get()), this.name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tryAcquire() {
        long currentTimeInMillis;
        long beenInOpenState;
        long value = this.state.get();
        CircuitBreaker.State state = this.getState(value);
        if (state == CircuitBreaker.State.CLOSED) {
            logger.trace("CircuitBreaker '{}' acquired", (Object)this.name);
            return true;
        }
        if (state == CircuitBreaker.State.HALF_OPEN) {
            short acquired = this.countHalfOpenAcquired(value);
            if (acquired < this.config.permittedCallsInHalfOpenState()) {
                boolean isAcquired = this.state.compareAndSet(value, value + 1L);
                if (!isAcquired) return this.tryAcquire();
                logger.trace("CircuitBreaker '{}' acquired", (Object)this.name);
            } else {
                logger.trace("CircuitBreaker '{}' can't be acquired in HALF_OPEN state", (Object)this.name);
                return false;
            }
        }
        if ((beenInOpenState = (currentTimeInMillis = this.clock.millis()) - value) >= this.waitDurationInOpenStateInMillis) {
            if (!this.state.compareAndSet(value, 0x4000000000000001L)) return this.tryAcquire();
            this.onStateChange(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN);
            logger.trace("CircuitBreaker '{}' acquired", (Object)this.name);
            return true;
        }
        if (!logger.isTraceEnabled()) return false;
        logger.trace("CircuitBreaker '{}' can't be acquired being in OPEN state for '{}' when require minimum '{}'", new Object[]{this.name, Duration.ofMillis(beenInOpenState), Duration.ofMillis(this.waitDurationInOpenStateInMillis)});
        return false;
    }

    @Override
    public void releaseOnSuccess() {
        long newStateLong;
        long currentStateLong;
        while (!this.state.compareAndSet(currentStateLong = this.state.get(), newStateLong = this.calculateStateOnSuccess(currentStateLong))) {
        }
        CircuitBreaker.State newState = this.getState(newStateLong);
        CircuitBreaker.State prevState = this.getState(currentStateLong);
        if (prevState != newState) {
            this.onStateChange(prevState, newState);
        }
        logger.trace("CircuitBreaker '{}' released on success", (Object)this.name);
    }

    private long calculateStateOnSuccess(long currentState) {
        CircuitBreaker.State state = this.getState(currentState);
        if (state == CircuitBreaker.State.CLOSED) {
            int total = this.countClosedTotal(currentState) + 1;
            if ((long)total == this.config.slidingWindowSize()) {
                return Long.MIN_VALUE;
            }
            return currentState + 1L;
        }
        if (state == CircuitBreaker.State.HALF_OPEN) {
            int permitted;
            int success = this.countHalfOpenSuccess(currentState) + 1;
            if (success >= (permitted = this.config.permittedCallsInHalfOpenState().intValue())) {
                return Long.MIN_VALUE;
            }
            short errors = this.countHalfOpenError(currentState);
            int total = success + errors;
            if (total >= permitted) {
                return this.getOpenState();
            }
            return currentState + 65536L;
        }
        return currentState;
    }

    @Override
    public void releaseOnError(@Nonnull Throwable throwable) {
        long newStateLong;
        long currentStateLong;
        if (!this.failurePredicate.test(throwable)) {
            return;
        }
        while (!this.state.compareAndSet(currentStateLong = this.state.get(), newStateLong = this.calculateStateOnFailure(currentStateLong))) {
        }
        CircuitBreaker.State newState = this.getState(newStateLong);
        CircuitBreaker.State prevState = this.getState(currentStateLong);
        if (prevState != newState) {
            this.onStateChange(prevState, newState);
        }
        logger.trace("CircuitBreaker '{}' released on error: {}", (Object)this.name, (Object)throwable.getClass().getCanonicalName());
    }

    private long calculateStateOnFailure(long currentState) {
        CircuitBreaker.State state = this.getState(currentState);
        if (state == CircuitBreaker.State.CLOSED) {
            int total = this.countClosedTotal(currentState) + 1;
            if ((long)total < this.config.minimumRequiredCalls()) {
                return currentState + 0x80000001L;
            }
            float errors = this.countClosedErrors(currentState) + 1;
            int failureRatePercentage = (int)(errors / (float)total * 100.0f);
            if (failureRatePercentage >= this.config.failureRateThreshold()) {
                return this.getOpenState();
            }
            if ((long)total == this.config.slidingWindowSize()) {
                return Long.MIN_VALUE;
            }
            return currentState + 0x80000001L;
        }
        if (state == CircuitBreaker.State.HALF_OPEN) {
            return this.getOpenState();
        }
        return currentState;
    }
}

