/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.fallback;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.fallback.Fallback;
import ru.tinkoff.kora.resilient.fallback.FallbackConfig;
import ru.tinkoff.kora.resilient.fallback.FallbackManager;
import ru.tinkoff.kora.resilient.fallback.FallbackMetrics;
import ru.tinkoff.kora.resilient.fallback.FallbackPredicate;
import ru.tinkoff.kora.resilient.fallback.KoraFallback;

final class KoraFallbackManager
implements FallbackManager {
    private static final Logger logger = LoggerFactory.getLogger(KoraFallbackManager.class);
    private final Map<String, Fallback> fallbackerMap = new ConcurrentHashMap<String, Fallback>();
    private final FallbackConfig configs;
    private final FallbackMetrics metrics;
    private final List<FallbackPredicate> failurePredicates;

    KoraFallbackManager(FallbackConfig configs, List<FallbackPredicate> failurePredicates, FallbackMetrics metrics) {
        this.configs = configs;
        this.metrics = metrics;
        this.failurePredicates = failurePredicates;
    }

    @Override
    @Nonnull
    public Fallback get(@Nonnull String name) {
        return this.fallbackerMap.computeIfAbsent(name, k -> {
            FallbackConfig.NamedConfig config = this.configs.getNamedConfig(name);
            FallbackPredicate failurePredicate = this.getFailurePredicate(config);
            logger.debug("Creating Fallback named '{}' with failure predicate '{}' and config {}", new Object[]{name, failurePredicate.name(), config});
            return new KoraFallback(name, this.metrics, failurePredicate);
        });
    }

    private FallbackPredicate getFailurePredicate(FallbackConfig.NamedConfig config) {
        return this.failurePredicates.stream().filter(p -> p.name().equals(config.failurePredicateName())).findFirst().orElseThrow(() -> new IllegalArgumentException("FailurePredicateClassName '" + config.failurePredicateName() + "' is not present as bean, please declare it as bean"));
    }
}

