/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.timeout.KoraTimeouterUtils;
import ru.tinkoff.kora.resilient.timeout.Timeout;
import ru.tinkoff.kora.resilient.timeout.TimeoutExhaustedException;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

record KoraTimeout(String name, long delayMaxNanos, TimeoutMetrics metrics, ExecutorService executor) implements Timeout
{
    private static final Logger logger = LoggerFactory.getLogger(KoraTimeout.class);

    @Override
    @Nonnull
    public Duration timeout() {
        return Duration.ofNanos(this.delayMaxNanos);
    }

    @Override
    public void execute(@Nonnull Runnable runnable) throws TimeoutExhaustedException {
        this.internalExecute(e -> e.submit(runnable));
    }

    @Override
    public <T> T execute(@Nonnull Callable<T> callable) throws TimeoutExhaustedException {
        return this.internalExecute(e -> e.submit(callable));
    }

    private <T> T internalExecute(Function<ExecutorService, Future<T>> consumer) throws TimeoutExhaustedException {
        try {
            if (logger.isTraceEnabled()) {
                Duration timeout = this.timeout();
                logger.trace("KoraTimeout '{}' starting await for {}", (Object)this.name, (Object)timeout);
            }
            return consumer.apply(this.executor).get(this.delayMaxNanos, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            KoraTimeouterUtils.doThrow(e.getCause());
        }
        catch (TimeoutException e) {
            Duration timeout = this.timeout();
            logger.debug("KoraTimeout '{}' registered timeout after: {}", (Object)this.name, (Object)timeout);
            this.metrics.recordTimeout(this.name, this.delayMaxNanos);
            throw new TimeoutExhaustedException(this.name, "Timeout exceeded " + timeout);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("Should not happen");
    }
}

