/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.resilient.timeout.KoraTimeoutManager;
import ru.tinkoff.kora.resilient.timeout.NoopTimeoutMetrics;
import ru.tinkoff.kora.resilient.timeout.TimeoutConfig;
import ru.tinkoff.kora.resilient.timeout.TimeoutManager;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;
import ru.tinkoff.kora.resilient.timeout.annotation.Timeout;

public interface TimeoutModule {
    default public TimeoutConfig koraTimeoutConfig(Config config, ConfigValueExtractor<TimeoutConfig> extractor) {
        ConfigValue value = config.get("resilient");
        return (TimeoutConfig)extractor.extract(value);
    }

    default public TimeoutManager koraTimeoutManager(@Tag(value={Timeout.class}) ExecutorService executorService, TimeoutConfig config, @Nullable TimeoutMetrics metrics) {
        return new KoraTimeoutManager(metrics == null ? new NoopTimeoutMetrics() : metrics, executorService, config);
    }

    @DefaultComponent
    @Tag(value={Timeout.class})
    default public ExecutorService koraTimeoutExecutorService() {
        return Executors.newCachedThreadPool();
    }
}

