/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.retry.KoraRetry;
import ru.tinkoff.kora.resilient.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetryConfig;
import ru.tinkoff.kora.resilient.retry.RetryManager;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;
import ru.tinkoff.kora.resilient.retry.RetryPredicate;

final class KoraRetryManager
implements RetryManager {
    private static final Logger logger = LoggerFactory.getLogger(KoraRetryManager.class);
    private final Map<String, Retry> retryableByName = new ConcurrentHashMap<String, Retry>();
    private final List<RetryPredicate> failurePredicates;
    private final RetryConfig config;
    private final RetryMetrics metrics;

    KoraRetryManager(RetryConfig config, List<RetryPredicate> failurePredicates, RetryMetrics metrics) {
        this.config = config;
        this.failurePredicates = failurePredicates;
        this.metrics = metrics;
    }

    @Override
    @Nonnull
    public Retry get(@Nonnull String name) {
        return this.retryableByName.computeIfAbsent(name, k -> {
            RetryConfig.NamedConfig config = this.config.getNamedConfig(name);
            RetryPredicate failurePredicate = this.getFailurePredicate(config);
            logger.debug("Creating Retry named '{}' with config {}", (Object)name, (Object)config);
            return new KoraRetry(name, config, failurePredicate, this.metrics);
        });
    }

    private RetryPredicate getFailurePredicate(RetryConfig.NamedConfig config) {
        return this.failurePredicates.stream().filter(p -> p.name().equals(config.failurePredicateName())).findFirst().orElseThrow(() -> new IllegalArgumentException("FailurePredicateClassName " + config.failurePredicateName() + " is not present as bean, please declare it as bean"));
    }
}

