/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;
import ru.tinkoff.kora.resilient.retry.RetryPredicate;

record KoraRetryState(String name, long started, long delayNanos, long delayStepNanos, int attemptsMax, RetryPredicate failurePredicate, RetryMetrics metrics, AtomicInteger attempts) implements Retry.RetryState
{
    private static final Logger logger = LoggerFactory.getLogger(KoraRetryState.class);

    @Override
    public int getAttempts() {
        int usedAttempts = this.attempts.get();
        return usedAttempts > this.attemptsMax ? this.attemptsMax : usedAttempts;
    }

    @Override
    public long getDelayNanos() {
        return this.delayNanos + this.delayStepNanos * (long)(this.attempts.get() - 1);
    }

    @Override
    @Nonnull
    public Retry.RetryState.RetryStatus onException(@Nonnull Throwable throwable) {
        if (!this.failurePredicate.test(throwable)) {
            logger.trace("RetryState '{}' rejected exception: {}", (Object)this.name, (Object)throwable.getClass().getCanonicalName());
            return Retry.RetryState.RetryStatus.REJECTED;
        }
        int attemptsUsed = this.attempts.incrementAndGet();
        if (attemptsUsed <= this.attemptsMax) {
            if (logger.isTraceEnabled()) {
                logger.trace("RetryState '{}' initiating '{}' retry attempt in '{}' due to exception: {}", new Object[]{this.name, attemptsUsed, Duration.ofNanos(this.getDelayNanos()), throwable.getClass().getCanonicalName()});
            }
            return Retry.RetryState.RetryStatus.ACCEPTED;
        }
        return Retry.RetryState.RetryStatus.EXHAUSTED;
    }

    @Override
    public void doDelay() {
        long nextDelayNanos = this.getDelayNanos();
        KoraRetryState.sleepUninterruptibly(nextDelayNanos);
    }

    @Override
    public void close() {
        int attemptsUsed = this.attempts.get();
        if (attemptsUsed > this.attemptsMax) {
            logger.debug("RetryState '{}' exhausted all '{}' retry attempts", (Object)this.name, (Object)this.attemptsMax);
            this.metrics.recordExhaustedAttempts(this.name, this.attemptsMax);
        } else if (attemptsUsed > 0) {
            logger.trace("RetryState '{}' success after '{}' failed retry attempts", (Object)this.name, (Object)attemptsUsed);
            for (int i = 1; i < attemptsUsed; ++i) {
                long attemptDelay = this.delayNanos + this.delayStepNanos * (long)i;
                this.metrics.recordAttempt(this.name, attemptDelay);
            }
        }
    }

    private static void sleepUninterruptibly(long sleepForNanos) {
        boolean interrupted = false;
        try {
            long remainingNanos = sleepForNanos;
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

