/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.circuitbreaker;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerConfig;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerManager;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerMetrics;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerPredicate;
import ru.tinkoff.kora.resilient.circuitbreaker.KoraCircuitBreaker;

final class KoraCircuitBreakerManager
implements CircuitBreakerManager {
    private static final Logger logger = LoggerFactory.getLogger(KoraCircuitBreakerManager.class);
    private final Map<String, CircuitBreaker> circuitBreakerMap = new ConcurrentHashMap<String, CircuitBreaker>();
    private final CircuitBreakerConfig config;
    private final List<CircuitBreakerPredicate> failurePredicates;
    private final CircuitBreakerMetrics metrics;

    KoraCircuitBreakerManager(CircuitBreakerConfig config, List<CircuitBreakerPredicate> failurePredicates, CircuitBreakerMetrics metrics) {
        this.config = config;
        this.failurePredicates = failurePredicates;
        this.metrics = metrics;
    }

    @Override
    @Nonnull
    public CircuitBreaker get(@Nonnull String name) {
        return this.circuitBreakerMap.computeIfAbsent(name, k -> {
            CircuitBreakerConfig.NamedConfig config = this.config.getNamedConfig(name);
            CircuitBreakerPredicate failurePredicate = this.getFailurePredicate(config);
            logger.debug("Creating CircuitBreaker named '{}' with failure predicate '{}' and config {}", new Object[]{name, failurePredicate.name(), config});
            return new KoraCircuitBreaker(name, config, failurePredicate, this.metrics);
        });
    }

    private CircuitBreakerPredicate getFailurePredicate(CircuitBreakerConfig.NamedConfig config) {
        return this.failurePredicates.stream().filter(p -> p.name().equals(config.failurePredicateName())).findFirst().orElseThrow(() -> new IllegalArgumentException("FailurePredicateClassName " + config.failurePredicateName() + " is not present as bean, please declare it as bean"));
    }
}

