/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import ru.tinkoff.kora.resilient.retry.KoraRetryState;
import ru.tinkoff.kora.resilient.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetryConfig;
import ru.tinkoff.kora.resilient.retry.RetryExhaustedException;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;
import ru.tinkoff.kora.resilient.retry.RetryPredicate;

final class KoraRetry
implements Retry {
    final String name;
    final long delayNanos;
    final long delayStepNanos;
    final int attempts;
    final RetryPredicate failurePredicate;
    final RetryMetrics metrics;

    KoraRetry(String name, long delayNanos, long delayStepNanos, int attempts, RetryPredicate failurePredicate, RetryMetrics metrics) {
        this.name = name;
        this.delayNanos = delayNanos;
        this.delayStepNanos = delayStepNanos;
        this.attempts = attempts;
        this.failurePredicate = failurePredicate;
        this.metrics = metrics;
    }

    KoraRetry(String name, RetryConfig.NamedConfig config, RetryPredicate failurePredicate, RetryMetrics metric) {
        this(name, config.delay().toNanos(), config.delayStep().toNanos(), config.attempts(), failurePredicate, metric);
    }

    @Override
    @Nonnull
    public Retry.RetryState asState() {
        return new KoraRetryState(this.name, System.nanoTime(), this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics, new AtomicInteger(0));
    }

    @Override
    public void retry(@Nonnull Runnable runnable) {
        this.internalRetry(() -> {
            runnable.run();
            return null;
        }, null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier) {
        return this.internalRetry(supplier, null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier, @Nonnull Supplier<T> fallback) {
        return this.internalRetry(supplier, fallback);
    }

    /*
     * Unable to fully structure code
     */
    private <T> T internalRetry(Supplier<T> consumer, @Nullable Supplier<T> fallback) {
        suppressed = new ArrayList<Exception>();
        state = this.asState();
        while (true) {
            try {
                var5_6 = consumer.get();
                return var5_6;
            }
            catch (Exception e) {
                status = state.onException(e);
                if (status == Retry.RetryState.RetryStatus.REJECTED) {
                    for (Exception exception : suppressed) {
                        e.addSuppressed(exception);
                    }
                    throw e;
                }
                if (status == Retry.RetryState.RetryStatus.ACCEPTED) {
                    suppressed.add(e);
                    state.doDelay();
                    continue;
                }
                if (status == Retry.RetryState.RetryStatus.EXHAUSTED) ** break;
                continue;
                if (fallback != null) {
                    try {
                        var7_11 = fallback.get();
                    }
                    catch (Exception ex) {
                        for (Exception exception : suppressed) {
                            ex.addSuppressed(exception);
                        }
                        throw ex;
                    }
                    return var7_11;
                }
                exhaustedException = new RetryExhaustedException(this.attempts, (Throwable)e);
                for (Exception exception : suppressed) {
                    exhaustedException.addSuppressed(exception);
                }
                throw exhaustedException;
            }
            break;
        }
        finally {
            if (state != null) {
                state.close();
            }
        }
    }
}

