/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.fallback;

import jakarta.annotation.Nonnull;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.fallback.Fallback;
import ru.tinkoff.kora.resilient.fallback.FallbackMetrics;
import ru.tinkoff.kora.resilient.fallback.FallbackPredicate;

final class KoraFallback
implements Fallback {
    private static final Logger logger = LoggerFactory.getLogger(KoraFallback.class);
    private final String name;
    private final FallbackMetrics metrics;
    private final FallbackPredicate failurePredicate;

    KoraFallback(String name, FallbackMetrics metrics, FallbackPredicate failurePredicate) {
        this.name = name;
        this.metrics = metrics;
        this.failurePredicate = failurePredicate;
    }

    @Override
    public boolean canFallback(Throwable throwable) {
        if (this.failurePredicate.test(throwable)) {
            logger.debug("Initiating Fallback '{}' due to: {}", (Object)this.name, (Object)throwable.getClass().getCanonicalName());
            this.metrics.recordExecute(this.name, throwable);
            return true;
        }
        return false;
    }

    @Override
    public void fallback(@Nonnull Runnable runnable, @Nonnull Runnable fallback) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            if (this.canFallback(e)) {
                fallback.run();
            }
            throw e;
        }
    }

    @Override
    public <T> T fallback(@Nonnull Supplier<T> supplier, @Nonnull Supplier<T> fallback) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            if (this.canFallback(e)) {
                return fallback.get();
            }
            throw e;
        }
    }
}

