/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.timeout.KoraTimeout;
import ru.tinkoff.kora.resilient.timeout.Timeout;
import ru.tinkoff.kora.resilient.timeout.TimeoutConfig;
import ru.tinkoff.kora.resilient.timeout.TimeoutManager;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

final class KoraTimeoutManager
implements TimeoutManager {
    private static final Logger logger = LoggerFactory.getLogger(KoraTimeoutManager.class);
    private final Map<String, Timeout> timeouterMap = new ConcurrentHashMap<String, Timeout>();
    private final TimeoutMetrics metrics;
    private final ExecutorService executor;
    private final TimeoutConfig config;

    KoraTimeoutManager(TimeoutMetrics metrics, ExecutorService executor, TimeoutConfig config) {
        this.metrics = metrics;
        this.executor = executor;
        this.config = config;
    }

    @Override
    @Nonnull
    public Timeout get(@Nonnull String name) {
        return this.timeouterMap.computeIfAbsent(name, k -> {
            TimeoutConfig.NamedConfig config = this.config.getNamedConfig(name);
            logger.debug("Creating Timeout named '{}' and config {}", (Object)name, (Object)config);
            return new KoraTimeout(name, config.duration().toNanos(), this.metrics, this.executor);
        });
    }
}

