/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.resilient.timeout.KoraTimeout;
import ru.tinkoff.kora.resilient.timeout.Timeout;
import ru.tinkoff.kora.resilient.timeout.TimeoutConfig;
import ru.tinkoff.kora.resilient.timeout.TimeoutExecutor;
import ru.tinkoff.kora.resilient.timeout.TimeoutManager;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

final class KoraTimeoutManager
implements TimeoutManager {
    private static final Logger logger = LoggerFactory.getLogger(KoraTimeoutManager.class);
    private final Map<String, Timeout> timeouterMap = new ConcurrentHashMap<String, Timeout>();
    private final TimeoutMetrics metrics;
    private final TimeoutExecutor timeoutExecutor;
    private final TimeoutConfig config;

    KoraTimeoutManager(TimeoutMetrics metrics, TimeoutExecutor timeoutExecutor, TimeoutConfig config) {
        this.metrics = metrics;
        this.timeoutExecutor = timeoutExecutor;
        this.config = config;
    }

    @Override
    @Nonnull
    public Timeout get(@Nonnull String name) {
        return this.timeouterMap.computeIfAbsent(name, k -> {
            TimeoutConfig.NamedConfig config = this.config.getNamedConfig(name);
            logger.debug("Creating Timeout named '{}' and config {}", (Object)name, (Object)config);
            return new KoraTimeout(name, config.duration().toNanos(), this.metrics, this.timeoutExecutor.executor());
        });
    }
}

