/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.application.graph.Lifecycle;

public class TimeoutExecutor
implements Lifecycle {
    private final ExecutorService executorService;

    public TimeoutExecutor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Nonnull
    public ExecutorService executor() {
        return this.executorService;
    }

    public void init() {
    }

    public void release() {
        if (this.executorService != null) {
            TimeoutExecutor.closeExecutorService(this.executorService);
        }
    }

    private static void closeExecutorService(ExecutorService executorService) {
        boolean terminated = executorService.isTerminated();
        if (!terminated) {
            executorService.shutdown();
            boolean interrupted = false;
            while (!terminated) {
                try {
                    terminated = executorService.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (interrupted) continue;
                    executorService.shutdownNow();
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

