/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nullable;
import java.util.concurrent.Executors;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.resilient.timeout.KoraTimeoutManager;
import ru.tinkoff.kora.resilient.timeout.NoopTimeoutMetrics;
import ru.tinkoff.kora.resilient.timeout.TimeoutConfig;
import ru.tinkoff.kora.resilient.timeout.TimeoutExecutor;
import ru.tinkoff.kora.resilient.timeout.TimeoutManager;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

public interface TimeoutModule {
    default public TimeoutConfig koraTimeoutConfig(Config config, ConfigValueExtractor<TimeoutConfig> extractor) {
        ConfigValue value = config.get("resilient");
        return (TimeoutConfig)extractor.extract(value);
    }

    default public TimeoutManager koraTimeoutManager(TimeoutExecutor timeoutExecutor, TimeoutConfig config, @Nullable TimeoutMetrics metrics) {
        TimeoutMetrics timeoutMetrics = metrics == null ? new NoopTimeoutMetrics() : metrics;
        return new KoraTimeoutManager(timeoutMetrics, timeoutExecutor, config);
    }

    @DefaultComponent
    default public TimeoutExecutor koraTimeoutExecutorService() {
        return new TimeoutExecutor(Executors.newCachedThreadPool());
    }
}

