/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.resilient.timeout.KoraTimeouterUtils;
import ru.tinkoff.kora.resilient.timeout.Timeout;
import ru.tinkoff.kora.resilient.timeout.TimeoutExhaustedException;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

record KoraTimeout(String name, long delayMaxNanos, TimeoutMetrics metrics, Executor executor) implements Timeout
{
    private static final Logger logger = LoggerFactory.getLogger(KoraTimeout.class);

    @Override
    @Nonnull
    public Duration timeout() {
        return Duration.ofNanos(this.delayMaxNanos);
    }

    @Override
    public void execute(@Nonnull Runnable runnable) throws TimeoutExhaustedException {
        this.internalExecute(e -> {
            CompletableFuture future = new CompletableFuture();
            Context current = Context.current();
            e.execute(() -> {
                try {
                    current.inject();
                    runnable.run();
                    future.complete(null);
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
            });
            return future;
        });
    }

    @Override
    public <T> T execute(@Nonnull Callable<T> callable) throws TimeoutExhaustedException {
        return this.internalExecute(e -> {
            CompletableFuture future = new CompletableFuture();
            Context current = Context.current();
            e.execute(() -> {
                try {
                    current.inject();
                    Object result = callable.call();
                    future.complete(result);
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
            });
            return future;
        });
    }

    private <T> T internalExecute(Function<Executor, Future<T>> consumer) throws TimeoutExhaustedException {
        if (logger.isTraceEnabled()) {
            Duration timeout = this.timeout();
            logger.trace("KoraTimeout '{}' starting await for {}", (Object)this.name, (Object)timeout);
        }
        Future<T> handler = consumer.apply(this.executor);
        try {
            return handler.get(this.delayMaxNanos, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            KoraTimeouterUtils.doThrow(e.getCause());
        }
        catch (TimeoutException e) {
            handler.cancel(true);
            Duration timeout = this.timeout();
            logger.debug("KoraTimeout '{}' registered timeout after: {}", (Object)this.name, (Object)timeout);
            this.metrics.recordTimeout(this.name, this.delayMaxNanos);
            throw new TimeoutExhaustedException(this.name, "Timeout exceeded " + String.valueOf(timeout));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("Should not happen");
    }
}

