/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import ru.tinkoff.kora.resilient.retry.RetryExhaustedException;

public interface Retry {
    @Nonnull
    public RetryState asState();

    public <E extends Throwable> void retry(@Nonnull RetryRunnable<E> var1) throws RetryExhaustedException, E;

    public <T, E extends Throwable> T retry(@Nonnull RetrySupplier<T, E> var1) throws RetryExhaustedException, E;

    public <T, E extends Throwable> T retry(@Nonnull RetrySupplier<T, E> var1, RetrySupplier<T, E> var2) throws E;

    public <T> CompletionStage<T> retry(@Nonnull Supplier<CompletionStage<T>> var1);

    public static interface RetryState
    extends AutoCloseable {
        @Nonnull
        public RetryStatus onException(@Nonnull Throwable var1);

        public int getAttempts();

        public int getAttemptsMax();

        public long getDelayNanos();

        public void doDelay();

        @Override
        public void close();

        public static enum RetryStatus {
            ACCEPTED,
            REJECTED,
            EXHAUSTED;

        }
    }

    @FunctionalInterface
    public static interface RetrySupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface RetryRunnable<E extends Throwable> {
        public void run() throws E;
    }
}

