/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.resilient.timeout.KoraTimeouterUtils;
import ru.tinkoff.kora.resilient.timeout.Timeout;
import ru.tinkoff.kora.resilient.timeout.TimeoutConfig;
import ru.tinkoff.kora.resilient.timeout.TimeoutExhaustedException;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

final class KoraTimeout
implements Timeout {
    private static final Logger logger = LoggerFactory.getLogger(KoraTimeout.class);
    private final String name;
    private final long delayMaxNanos;
    private final TimeoutMetrics metrics;
    private final TimeoutConfig.NamedConfig config;
    private final Executor executor;

    KoraTimeout(String name, long delayMaxNanos, TimeoutMetrics metrics, TimeoutConfig.NamedConfig config, Executor executor) {
        this.name = name;
        this.delayMaxNanos = delayMaxNanos;
        this.metrics = metrics;
        this.config = config;
        this.executor = executor;
    }

    @Override
    @Nonnull
    public Duration timeout() {
        if (!this.config.enabled().booleanValue()) {
            logger.debug("Timeout '{}' is disabled", (Object)this.name);
            return Duration.ZERO;
        }
        return Duration.ofNanos(this.delayMaxNanos);
    }

    @Override
    public void execute(@Nonnull Runnable runnable) throws TimeoutExhaustedException {
        if (!this.config.enabled().booleanValue()) {
            logger.debug("Timeout '{}' is disabled", (Object)this.name);
            runnable.run();
        }
        this.internalExecute(e -> {
            CompletableFuture future = new CompletableFuture();
            Context current = Context.current();
            e.execute(() -> {
                try {
                    current.inject();
                    runnable.run();
                    future.complete(null);
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
            });
            return future;
        });
    }

    @Override
    public <T> T execute(@Nonnull Callable<T> callable) throws TimeoutExhaustedException {
        if (!this.config.enabled().booleanValue()) {
            logger.debug("Timeout '{}' is disabled", (Object)this.name);
            try {
                return callable.call();
            }
            catch (Exception e2) {
                KoraTimeouterUtils.doThrow(e2.getCause());
                throw new IllegalStateException("Should not happen");
            }
        }
        return this.internalExecute(e -> {
            CompletableFuture future = new CompletableFuture();
            Context current = Context.current();
            e.execute(() -> {
                try {
                    current.inject();
                    Object result = callable.call();
                    future.complete(result);
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
            });
            return future;
        });
    }

    private <T> T internalExecute(Function<Executor, Future<T>> consumer) throws TimeoutExhaustedException {
        if (logger.isTraceEnabled()) {
            Duration timeout = this.timeout();
            logger.trace("KoraTimeout '{}' starting await for {}", (Object)this.name, (Object)timeout);
        }
        Future<T> handler = consumer.apply(this.executor);
        try {
            return handler.get(this.delayMaxNanos, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            KoraTimeouterUtils.doThrow(e.getCause());
        }
        catch (TimeoutException e) {
            handler.cancel(true);
            Duration timeout = this.timeout();
            logger.debug("KoraTimeout '{}' registered timeout after: {}", (Object)this.name, (Object)timeout);
            this.metrics.recordTimeout(this.name, this.delayMaxNanos);
            throw new TimeoutExhaustedException(this.name, "Timeout exceeded " + String.valueOf(timeout));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("Should not happen");
    }

    public String name() {
        return this.name;
    }

    public long delayMaxNanos() {
        return this.delayMaxNanos;
    }

    public TimeoutMetrics metrics() {
        return this.metrics;
    }

    public TimeoutConfig.NamedConfig config() {
        return this.config;
    }

    public Executor executor() {
        return this.executor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KoraTimeout that = (KoraTimeout)obj;
        return Objects.equals(this.name, that.name) && this.delayMaxNanos == that.delayMaxNanos && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.config, that.config) && Objects.equals(this.executor, that.executor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delayMaxNanos, this.metrics, this.config, this.executor);
    }

    public String toString() {
        return "KoraTimeout[name=" + this.name + ", delayMaxNanos=" + this.delayMaxNanos + ", metrics=" + String.valueOf(this.metrics) + ", config=" + String.valueOf(this.config) + ", executor=" + String.valueOf(this.executor) + "]";
    }
}

